/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.api.TypeRegistry;
import io.cucumber.core.api.TypeRegistryConfigurer;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.resource.ClasspathScanner;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.runner.Options;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ScanningTypeRegistryConfigurerSupplier
implements TypeRegistryConfigurerSupplier {
    private final Reflections reflections;
    private final Options options;

    public ScanningTypeRegistryConfigurerSupplier(Supplier<ClassLoader> classLoader, Options options) {
        this.options = options;
        this.reflections = new Reflections(new ClasspathScanner(classLoader));
    }

    @Override
    public TypeRegistryConfigurer get() {
        return this.reflections.instantiateExactlyOneSubclass(TypeRegistryConfigurer.class, this.options.getGlue(), new DefaultTypeRegistryConfiguration());
    }

    static final class TooManyInstancesException
    extends CucumberException {
        TooManyInstancesException(Collection<?> instances) {
            super(TooManyInstancesException.createMessage(instances));
        }

        private static String createMessage(Collection<?> instances) {
            Objects.requireNonNull(instances);
            return String.format("Expected only one instance, but found too many: %s", instances);
        }
    }

    static final class NoInstancesException
    extends CucumberException {
        NoInstancesException(Class<?> parentType) {
            super(NoInstancesException.createMessage(parentType));
        }

        private static String createMessage(Class<?> parentType) {
            return String.format("Couldn't find a single implementation of %s", parentType);
        }
    }

    static final class Reflections {
        private final ClasspathScanner classFinder;

        Reflections(ClasspathScanner classFinder) {
            this.classFinder = classFinder;
        }

        static boolean isInstantiable(Class<?> clazz) {
            boolean isNonStaticInnerClass = !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
            return Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && !isNonStaticInnerClass;
        }

        <T> T instantiateExactlyOneSubclass(Class<T> parentType, List<URI> packageNames, T fallback) {
            Collection<T> instances = this.instantiateSubclasses(parentType, packageNames);
            if (instances.size() == 1) {
                return instances.iterator().next();
            }
            if (instances.isEmpty()) {
                if (fallback != null) {
                    return fallback;
                }
                throw new NoInstancesException(parentType);
            }
            throw new TooManyInstancesException(instances);
        }

        private <T> Collection<? extends T> instantiateSubclasses(Class<T> parentType, List<URI> packageNames) {
            return packageNames.stream().filter(gluePath -> "classpath".equals(gluePath.getScheme())).map(ClasspathSupport::packageName).map(basePackageName -> this.classFinder.scanForSubClassesInPackage((String)basePackageName, parentType)).flatMap(Collection::stream).filter(Reflections::isInstantiable).map(Reflections::newInstance).collect(Collectors.toSet());
        }

        private static <T> T newInstance(Class<? extends T> clazz) {
            try {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new CucumberException("Failed to instantiate " + constructor.toGenericString(), e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new CucumberException(e);
            }
        }
    }

    private static final class DefaultTypeRegistryConfiguration
    implements TypeRegistryConfigurer {
        private DefaultTypeRegistryConfiguration() {
        }

        @Override
        public Locale locale() {
            return Locale.ENGLISH;
        }

        @Override
        public void configureTypeRegistry(TypeRegistry typeRegistry) {
        }
    }
}

