/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeaturePath;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FeatureWithLines
implements Serializable {
    private static final long serialVersionUID = 20190126L;
    private static final Pattern FEATURE_COLON_LINE_PATTERN = Pattern.compile("^(.*?):([\\d:]+)$");
    private static final String INVALID_PATH_MESSAGE = " is not valid. Try <uri or path>/<name>.feature[:LINE]*";
    private final URI uri;
    private final SortedSet<Integer> lines;

    private FeatureWithLines(URI uri, Collection<Integer> lines) {
        this.uri = uri;
        this.lines = Collections.unmodifiableSortedSet(new TreeSet<Integer>(lines));
    }

    public static FeatureWithLines create(URI uri, Collection<Integer> lines) {
        if (lines.isEmpty()) {
            return new FeatureWithLines(uri, lines);
        }
        return new FeatureWithLines(FeatureIdentifier.parse(uri), lines);
    }

    public static FeatureWithLines parse(String uri, Collection<Integer> lines) {
        return FeatureWithLines.create(FeaturePath.parse(uri), lines);
    }

    public static FeatureWithLines parse(String featurePath) {
        Matcher matcher = FEATURE_COLON_LINE_PATTERN.matcher(featurePath);
        try {
            if (!matcher.matches()) {
                return FeatureWithLines.parseFeaturePath(featurePath);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(featurePath + INVALID_PATH_MESSAGE, e);
        }
        String uriGroup = matcher.group(1);
        if (uriGroup.isEmpty()) {
            throw new IllegalArgumentException(featurePath + INVALID_PATH_MESSAGE);
        }
        try {
            return FeatureWithLines.parseFeatureIdentifierAndLines(uriGroup, matcher.group(2));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(featurePath + INVALID_PATH_MESSAGE, e);
        }
    }

    private static FeatureWithLines parseFeatureIdentifierAndLines(String uriGroup, String linesGroup) {
        List<Integer> lines = FeatureWithLines.toInts(linesGroup.split(":"));
        return FeatureWithLines.parse(uriGroup, lines);
    }

    private static FeatureWithLines parseFeaturePath(String pathName) {
        return FeatureWithLines.create(FeaturePath.parse(pathName), Collections.emptyList());
    }

    private static List<Integer> toInts(String[] strings) {
        return Arrays.stream(strings).map(Integer::parseInt).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.uri.toString());
        for (Integer line : this.lines) {
            builder.append(':');
            builder.append(line);
        }
        return builder.toString();
    }

    public SortedSet<Integer> lines() {
        return this.lines;
    }

    public URI uri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureWithLines that = (FeatureWithLines)o;
        return this.uri.equals(that.uri) && this.lines.equals(that.lines);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.lines);
    }
}

