/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.Status;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.WriteEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

class TestCaseState
implements io.cucumber.core.backend.TestCaseState {
    private final List<Result> stepResults = new ArrayList<Result>();
    private final EventBus bus;
    private final TestCase testCase;

    TestCaseState(EventBus bus, TestCase testCase) {
        this.bus = Objects.requireNonNull(bus);
        this.testCase = Objects.requireNonNull(testCase);
    }

    void add(Result result) {
        this.stepResults.add(result);
    }

    @Override
    public Collection<String> getSourceTagNames() {
        return this.testCase.getTags();
    }

    @Override
    public Status getStatus() {
        if (this.stepResults.isEmpty()) {
            return Status.UNDEFINED;
        }
        Result mostSevereResult = Collections.max(this.stepResults, Comparator.comparing(Result::getStatus));
        return Status.valueOf(mostSevereResult.getStatus().name());
    }

    @Override
    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    @Override
    @Deprecated
    public void embed(byte[] data, String mediaType) {
        this.bus.send((Event)new EmbedEvent(this.bus.getInstant(), this.testCase, data, mediaType));
    }

    @Override
    public void embed(byte[] data, String mediaType, String name) {
        this.bus.send((Event)new EmbedEvent(this.bus.getInstant(), this.testCase, data, mediaType, name));
    }

    @Override
    public void write(String text) {
        this.bus.send((Event)new WriteEvent(this.bus.getInstant(), this.testCase, text));
    }

    @Override
    public String getName() {
        return this.testCase.getName();
    }

    @Override
    public String getId() {
        return this.testCase.getUri() + ":" + this.getLine();
    }

    @Override
    public URI getUri() {
        return this.testCase.getUri();
    }

    @Override
    public Integer getLine() {
        return this.testCase.getLine();
    }

    Throwable getError() {
        if (this.stepResults.isEmpty()) {
            return null;
        }
        return Collections.max(this.stepResults, Comparator.comparing(Result::getStatus)).getError();
    }
}

