/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import io.cucumber.core.resource.ClasspathSupport;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class GluePath {
    private GluePath() {
    }

    public static URI parse(String gluePath) {
        Objects.requireNonNull(gluePath, "gluePath may not be null");
        if (gluePath.isEmpty()) {
            return ClasspathSupport.rootPackage();
        }
        if ("classpath:".equals(gluePath)) {
            return ClasspathSupport.rootPackage();
        }
        if (GluePath.nonStandardPathSeparatorInUse(gluePath)) {
            String standardized = GluePath.replaceNonStandardPathSeparator(gluePath);
            return GluePath.parseAssumeClasspathScheme(standardized);
        }
        if (GluePath.isProbablyPackage(gluePath)) {
            String path = GluePath.replacePackageSeparator(gluePath);
            return GluePath.parseAssumeClasspathScheme(path);
        }
        return GluePath.parseAssumeClasspathScheme(gluePath);
    }

    private static boolean isProbablyPackage(String gluePath) {
        return gluePath.contains(ClasspathSupport.PACKAGE_SEPARATOR_STRING) && !gluePath.contains(ClasspathSupport.RESOURCE_SEPARATOR_STRING);
    }

    private static String replacePackageSeparator(String gluePath) {
        return ClasspathSupport.packagePath(gluePath);
    }

    private static String replaceNonStandardPathSeparator(String featureIdentifier) {
        return featureIdentifier.replace(File.separatorChar, '/');
    }

    private static boolean nonStandardPathSeparatorInUse(String featureIdentifier) {
        return File.separatorChar != '/' && featureIdentifier.contains(File.separator);
    }

    private static URI parseAssumeClasspathScheme(String gluePath) {
        URI uri = URI.create(gluePath);
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        if (!GluePath.isValidIdentifier(schemeSpecificPart)) {
            throw new IllegalArgumentException("The glue path contained invalid identifiers " + uri);
        }
        if (uri.getScheme() == null) {
            try {
                return new URI("classpath", schemeSpecificPart.startsWith("/") ? schemeSpecificPart : "/" + schemeSpecificPart, uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        if (!"classpath".equals(uri.getScheme())) {
            throw new IllegalArgumentException("The glue path must have a classpath scheme " + uri);
        }
        return uri;
    }

    private static boolean isValidIdentifier(String schemeSpecificPart) {
        for (String part : schemeSpecificPart.split("/")) {
            for (int i = 0; i < part.length(); ++i) {
                if ((i != 0 || Character.isJavaIdentifierStart(part.charAt(i))) && (i == 0 || Character.isJavaIdentifierPart(part.charAt(i)))) continue;
                return false;
            }
        }
        return true;
    }
}

