/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.AbstractEventBus;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.runner.Options;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventHandler;
import java.time.Instant;

public final class ThreadLocalRunnerSupplier
implements RunnerSupplier {
    private final BackendSupplier backendSupplier;
    private final Options runnerOptions;
    private final SynchronizedEventBus sharedEventBus;
    private final ObjectFactorySupplier objectFactorySupplier;
    private final TypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier;
    private final ThreadLocal<Runner> runners = ThreadLocal.withInitial(this::createRunner);

    public ThreadLocalRunnerSupplier(Options runnerOptions, EventBus sharedEventBus, BackendSupplier backendSupplier, ObjectFactorySupplier objectFactorySupplier, TypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier) {
        this.runnerOptions = runnerOptions;
        this.sharedEventBus = SynchronizedEventBus.synchronize(sharedEventBus);
        this.backendSupplier = backendSupplier;
        this.objectFactorySupplier = objectFactorySupplier;
        this.typeRegistryConfigurerSupplier = typeRegistryConfigurerSupplier;
    }

    @Override
    public Runner get() {
        return this.runners.get();
    }

    private Runner createRunner() {
        return new Runner(new LocalEventBus(this.sharedEventBus), this.backendSupplier.get(), this.objectFactorySupplier.get(), this.typeRegistryConfigurerSupplier.get(), this.runnerOptions);
    }

    private static final class SynchronizedEventBus
    implements EventBus {
        private final EventBus delegate;

        static SynchronizedEventBus synchronize(EventBus eventBus) {
            if (eventBus instanceof SynchronizedEventBus) {
                return (SynchronizedEventBus)eventBus;
            }
            return new SynchronizedEventBus(eventBus);
        }

        private SynchronizedEventBus(EventBus delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized void send(Event event) {
            this.delegate.send(event);
        }

        @Override
        public synchronized void sendAll(Iterable<Event> events) {
            this.delegate.sendAll(events);
        }

        public synchronized <T extends Event> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
            this.delegate.registerHandlerFor(eventType, handler);
        }

        public synchronized <T extends Event> void removeHandlerFor(Class<T> eventType, EventHandler<T> handler) {
            this.delegate.removeHandlerFor(eventType, handler);
        }

        @Override
        public Instant getInstant() {
            return this.delegate.getInstant();
        }
    }

    private static final class LocalEventBus
    extends AbstractEventBus {
        private final SynchronizedEventBus parent;

        LocalEventBus(SynchronizedEventBus parent) {
            this.parent = parent;
        }

        @Override
        public void send(Event event) {
            super.send(event);
            this.parent.send(event);
        }

        @Override
        public Instant getInstant() {
            return this.parent.getInstant();
        }
    }
}

