/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.CompositeCucumberException;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.CucumberFeature;
import io.cucumber.core.feature.CucumberPickle;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.order.PickleOrder;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.FeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.SingletonObjectFactorySupplier;
import io.cucumber.core.runtime.SingletonRunnerSupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Runtime {
    private static final Logger log = LoggerFactory.getLogger(Runtime.class);
    private final ExitStatus exitStatus;
    private final RunnerSupplier runnerSupplier;
    private final Predicate<CucumberPickle> filter;
    private final int limit;
    private final EventBus bus;
    private final FeatureSupplier featureSupplier;
    private final ExecutorService executor;
    private final PickleOrder pickleOrder;

    private Runtime(ExitStatus exitStatus, EventBus bus, Predicate<CucumberPickle> filter, int limit, RunnerSupplier runnerSupplier, FeatureSupplier featureSupplier, ExecutorService executor, PickleOrder pickleOrder) {
        this.bus = bus;
        this.filter = filter;
        this.limit = limit;
        this.runnerSupplier = runnerSupplier;
        this.featureSupplier = featureSupplier;
        this.executor = executor;
        this.exitStatus = exitStatus;
        this.pickleOrder = pickleOrder;
    }

    public void run() {
        List<CucumberFeature> features = this.featureSupplier.get();
        this.bus.send((Event)new TestRunStarted(this.bus.getInstant()));
        for (CucumberFeature feature2 : features) {
            this.bus.send((Event)new TestSourceRead(this.bus.getInstant(), feature2.getUri(), feature2.getSource()));
        }
        List executingPickles = features.stream().flatMap(feature -> feature.getPickles().stream()).filter(this.filter).collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.pickleOrder.orderPickles((List<CucumberPickle>)list).stream())).limit(this.limit > 0 ? (long)this.limit : Integer.MAX_VALUE).map(pickle -> this.executor.submit(() -> this.runnerSupplier.get().runPickle((CucumberPickle)pickle))).collect(Collectors.toList());
        this.executor.shutdown();
        ArrayList<Throwable> thrown = new ArrayList<Throwable>();
        for (Future executingPickle : executingPickles) {
            try {
                executingPickle.get();
            }
            catch (ExecutionException e) {
                log.error(e, () -> "Exception while executing pickle");
                thrown.add(e.getCause());
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                throw new CucumberException(e);
            }
        }
        if (thrown.size() == 1) {
            throw new CucumberException((Throwable)thrown.get(0));
        }
        if (thrown.size() > 1) {
            throw new CompositeCucumberException(thrown);
        }
        this.bus.send((Event)new TestRunFinished(this.bus.getInstant()));
    }

    public byte exitStatus() {
        return this.exitStatus.exitStatus();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class ExitStatus
    implements ConcurrentEventListener {
        private static final byte DEFAULT = 0;
        private static final byte ERRORS = 1;
        private final List<Result> results = new ArrayList<Result>();
        private final RuntimeOptions runtimeOptions;
        private final EventHandler<TestCaseFinished> testCaseFinishedHandler = event -> this.results.add(event.getResult());

        ExitStatus(RuntimeOptions runtimeOptions) {
            this.runtimeOptions = runtimeOptions;
        }

        public void setEventPublisher(EventPublisher publisher) {
            publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        }

        byte exitStatus() {
            if (this.results.isEmpty()) {
                return 0;
            }
            if (this.runtimeOptions.isWip()) {
                Result leastSeverResult = Collections.min(this.results, Comparator.comparing(Result::getStatus));
                return leastSeverResult.getStatus().is(Status.PASSED) ? (byte)1 : 0;
            }
            Result mostSevereResult = Collections.max(this.results, Comparator.comparing(Result::getStatus));
            return mostSevereResult.getStatus().isOk(this.runtimeOptions.isStrict()) ? (byte)0 : 1;
        }
    }

    private static final class SameThreadExecutorService
    extends AbstractExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }

    private static final class CucumberThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "cucumber-runner-" + poolNumber.getAndIncrement() + "-thread-";

        CucumberThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
        }
    }

    public static class Builder {
        private EventBus eventBus = new TimeServiceEventBus(Clock.systemUTC());
        private Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        private RuntimeOptions runtimeOptions = RuntimeOptions.defaultOptions();
        private BackendSupplier backendSupplier;
        private FeatureSupplier featureSupplier;
        private List<Plugin> additionalPlugins = Collections.emptyList();

        private Builder() {
        }

        public Builder withRuntimeOptions(RuntimeOptions runtimeOptions) {
            this.runtimeOptions = runtimeOptions;
            return this;
        }

        public Builder withClassLoader(Supplier<ClassLoader> classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder withBackendSupplier(BackendSupplier backendSupplier) {
            this.backendSupplier = backendSupplier;
            return this;
        }

        public Builder withFeatureSupplier(FeatureSupplier featureSupplier) {
            this.featureSupplier = featureSupplier;
            return this;
        }

        public Builder withAdditionalPlugins(Plugin ... plugins) {
            this.additionalPlugins = Arrays.asList(plugins);
            return this;
        }

        public Builder withEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Runtime build() {
            ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader(this.runtimeOptions);
            ObjectFactorySupplier objectFactorySupplier = this.runtimeOptions.isMultiThreaded() ? new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader) : new SingletonObjectFactorySupplier(objectFactoryServiceLoader);
            BackendSupplier backendSupplier = this.backendSupplier != null ? this.backendSupplier : new BackendServiceLoader(this.classLoader, objectFactorySupplier);
            Plugins plugins = new Plugins(new PluginFactory(), this.runtimeOptions);
            for (Plugin plugin : this.additionalPlugins) {
                plugins.addPlugin(plugin);
            }
            ExitStatus exitStatus = new ExitStatus(this.runtimeOptions);
            plugins.addPlugin((Plugin)exitStatus);
            if (this.runtimeOptions.isMultiThreaded()) {
                plugins.setSerialEventBusOnEventListenerPlugins(this.eventBus);
            } else {
                plugins.setEventBusOnEventListenerPlugins(this.eventBus);
            }
            ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(this.classLoader, this.runtimeOptions);
            RunnerSupplier runnerSupplier = this.runtimeOptions.isMultiThreaded() ? new ThreadLocalRunnerSupplier(this.runtimeOptions, this.eventBus, backendSupplier, objectFactorySupplier, typeRegistryConfigurerSupplier) : new SingletonRunnerSupplier(this.runtimeOptions, this.eventBus, backendSupplier, objectFactorySupplier, typeRegistryConfigurerSupplier);
            SameThreadExecutorService executor = this.runtimeOptions.isMultiThreaded() ? Executors.newFixedThreadPool(this.runtimeOptions.getThreads(), new CucumberThreadFactory()) : new SameThreadExecutorService();
            FeatureSupplier featureSupplier = this.featureSupplier != null ? this.featureSupplier : new FeaturePathFeatureSupplier(this.classLoader, this.runtimeOptions);
            Filters filter = new Filters(this.runtimeOptions);
            int limit = this.runtimeOptions.getLimitCount();
            PickleOrder pickleOrder = this.runtimeOptions.getPickleOrder();
            return new Runtime(exitStatus, this.eventBus, filter, limit, runnerSupplier, featureSupplier, executor, pickleOrder);
        }
    }
}

