/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.feature.CucumberFeature;
import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.core.runtime.FeatureSupplier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class FeaturePathFeatureSupplier
implements FeatureSupplier {
    private static final Logger log = LoggerFactory.getLogger(FeaturePathFeatureSupplier.class);
    private final ResourceScanner<CucumberFeature> featureScanner;
    private final Options featureOptions;

    public FeaturePathFeatureSupplier(Supplier<ClassLoader> classLoader, Options featureOptions) {
        this.featureOptions = featureOptions;
        this.featureScanner = new ResourceScanner(classLoader, FeatureIdentifier::isFeature, resource -> Optional.of(FeatureParser.parseResource(resource)));
    }

    @Override
    public List<CucumberFeature> get() {
        List<URI> featurePaths = this.featureOptions.getFeaturePaths();
        List<CucumberFeature> features = this.loadFeatures(featurePaths);
        if (features.isEmpty()) {
            if (featurePaths.isEmpty()) {
                log.warn(() -> "Got no path to feature directory or feature file");
            } else {
                log.warn(() -> "No features found at " + featurePaths.stream().map(URI::toString).collect(Collectors.joining(", ")));
            }
        }
        return features;
    }

    private List<CucumberFeature> loadFeatures(List<URI> featurePaths) {
        log.debug(() -> "Loading features from " + featurePaths.stream().map(URI::toString).collect(Collectors.joining(", ")));
        FeatureBuilder builder = new FeatureBuilder();
        for (URI featurePath : featurePaths) {
            List<CucumberFeature> found = this.featureScanner.scanForResourcesUri(featurePath);
            if (found.isEmpty() && FeatureIdentifier.isFeature(featurePath)) {
                throw new IllegalArgumentException("Feature not found: " + featurePath);
            }
            found.forEach(builder::addUnique);
        }
        return builder.build();
    }

    static final class FeatureBuilder {
        private final Map<String, Map<String, CucumberFeature>> sourceToFeature = new HashMap<String, Map<String, CucumberFeature>>();
        private final List<CucumberFeature> features = new ArrayList<CucumberFeature>();

        FeatureBuilder() {
        }

        List<CucumberFeature> build() {
            ArrayList<CucumberFeature> cucumberFeatures = new ArrayList<CucumberFeature>(this.features);
            cucumberFeatures.sort(Comparator.comparing(CucumberFeature::getUri));
            return cucumberFeatures;
        }

        void addUnique(CucumberFeature parsedFeature) {
            CucumberFeature existingFeature;
            String parsedFileName = this.getFileName(parsedFeature);
            Map<String, CucumberFeature> existingFeatures = this.sourceToFeature.get(parsedFeature.getSource());
            if (existingFeatures != null && (existingFeature = existingFeatures.get(parsedFileName)) != null) {
                log.error(() -> "Duplicate feature found: " + parsedFeature.getUri() + " was identical to " + existingFeature.getUri() + "\n\nThis typically happens when you configure cucumber to look for features in the root of your project.\nYour build tool creates a copy of these features in a 'target' or 'build'directory.\n\nIf your features are on the class path consider using a class path URI.\nFor example: 'classpath:com/example/app.feature'\nOtherwise you'll have to provide a more specific location");
                return;
            }
            this.sourceToFeature.putIfAbsent(parsedFeature.getSource(), new HashMap());
            this.sourceToFeature.get(parsedFeature.getSource()).put(parsedFileName, parsedFeature);
            this.features.add(parsedFeature);
        }

        private String getFileName(CucumberFeature feature) {
            String uri = feature.getUri().getSchemeSpecificPart();
            int i = uri.lastIndexOf("/");
            return i > 0 ? uri.substring(i) : uri;
        }
    }
}

