/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.Pending;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.runner.AmbiguousStepDefinitionsException;
import io.cucumber.core.runner.StepDefinitionMatch;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.core.runner.UndefinedStepDefinitionException;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;

abstract class TestStep
implements io.cucumber.plugin.event.TestStep {
    private static final String[] ASSUMPTION_VIOLATED_EXCEPTIONS = new String[]{"org.junit.AssumptionViolatedException", "org.junit.internal.AssumptionViolatedException", "org.opentest4j.TestAbortedException", "org.testng.SkipException"};
    private final StepDefinitionMatch stepDefinitionMatch;

    TestStep(StepDefinitionMatch stepDefinitionMatch) {
        this.stepDefinitionMatch = stepDefinitionMatch;
    }

    public String getCodeLocation() {
        return this.stepDefinitionMatch.getCodeLocation();
    }

    boolean run(TestCase testCase, EventBus bus, TestCaseState state, boolean skipSteps) {
        Status status;
        Instant startTimeMillis = bus.getInstant();
        bus.send((Event)new TestStepStarted(startTimeMillis, testCase, (io.cucumber.plugin.event.TestStep)this));
        Throwable error = null;
        try {
            status = this.executeStep(state, skipSteps);
        }
        catch (Throwable t) {
            error = t;
            status = this.mapThrowableToStatus(t);
        }
        Instant stopTimeNanos = bus.getInstant();
        Result result = this.mapStatusToResult(status, error, Duration.between(startTimeMillis, stopTimeNanos));
        state.add(result);
        bus.send((Event)new TestStepFinished(stopTimeNanos, testCase, (io.cucumber.plugin.event.TestStep)this, result));
        return !result.getStatus().is(Status.PASSED);
    }

    private Status executeStep(TestCaseState state, boolean skipSteps) throws Throwable {
        if (!skipSteps) {
            this.stepDefinitionMatch.runStep(state);
            return Status.PASSED;
        }
        this.stepDefinitionMatch.dryRunStep(state);
        return Status.SKIPPED;
    }

    private Status mapThrowableToStatus(Throwable t) {
        if (t.getClass().isAnnotationPresent(Pending.class)) {
            return Status.PENDING;
        }
        if (Arrays.binarySearch(ASSUMPTION_VIOLATED_EXCEPTIONS, t.getClass().getName()) >= 0) {
            return Status.SKIPPED;
        }
        if (t.getClass() == UndefinedStepDefinitionException.class) {
            return Status.UNDEFINED;
        }
        if (t.getClass() == AmbiguousStepDefinitionsException.class) {
            return Status.AMBIGUOUS;
        }
        return Status.FAILED;
    }

    private Result mapStatusToResult(Status status, Throwable error, Duration duration) {
        if (status == Status.UNDEFINED) {
            return new Result(status, Duration.ZERO, null);
        }
        return new Result(status, duration, error);
    }

    static {
        Arrays.sort(ASSUMPTION_VIOLATED_EXCEPTIONS);
    }
}

