/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.CucumberPickle;
import io.cucumber.core.runner.HookTestStep;
import io.cucumber.core.runner.PickleStepTestStep;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestStep;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

final class TestCase
implements io.cucumber.plugin.event.TestCase {
    private final CucumberPickle pickle;
    private final List<PickleStepTestStep> testSteps;
    private final boolean dryRun;
    private final List<HookTestStep> beforeHooks;
    private final List<HookTestStep> afterHooks;

    TestCase(List<PickleStepTestStep> testSteps, List<HookTestStep> beforeHooks, List<HookTestStep> afterHooks, CucumberPickle pickle, boolean dryRun) {
        this.testSteps = testSteps;
        this.beforeHooks = beforeHooks;
        this.afterHooks = afterHooks;
        this.pickle = pickle;
        this.dryRun = dryRun;
    }

    void run(EventBus bus) {
        boolean skipNextStep = this.dryRun;
        Instant start = bus.getInstant();
        bus.send((Event)new TestCaseStarted(start, (io.cucumber.plugin.event.TestCase)this));
        TestCaseState state = new TestCaseState(bus, this);
        for (HookTestStep before : this.beforeHooks) {
            skipNextStep |= before.run(this, bus, state, this.dryRun);
        }
        for (PickleStepTestStep step : this.testSteps) {
            skipNextStep |= step.run(this, bus, state, skipNextStep);
        }
        for (HookTestStep after : this.afterHooks) {
            after.run(this, bus, state, this.dryRun);
        }
        Instant stop = bus.getInstant();
        Duration duration = Duration.between(start, stop);
        Status status = Status.valueOf((String)state.getStatus().name());
        Result result = new Result(status, duration, state.getError());
        bus.send((Event)new TestCaseFinished(stop, (io.cucumber.plugin.event.TestCase)this, result));
    }

    public List<TestStep> getTestSteps() {
        ArrayList<TestStep> testSteps = new ArrayList<TestStep>(this.beforeHooks);
        for (PickleStepTestStep step : this.testSteps) {
            testSteps.addAll(step.getBeforeStepHookSteps());
            testSteps.add(step);
            testSteps.addAll(step.getAfterStepHookSteps());
        }
        testSteps.addAll(this.afterHooks);
        return testSteps;
    }

    public String getName() {
        return this.pickle.getName();
    }

    public String getScenarioDesignation() {
        return this.fileColonLine(this.getLine()) + " # " + this.getName();
    }

    public URI getUri() {
        return this.pickle.getUri();
    }

    public Integer getLine() {
        return this.pickle.getLocation().getLine();
    }

    private String fileColonLine(Integer line) {
        return this.pickle.getUri().getSchemeSpecificPart() + ":" + line;
    }

    public List<String> getTags() {
        return this.pickle.getTags();
    }
}

