/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.CucumberStep;
import io.cucumber.core.runner.DefinitionArgument;
import io.cucumber.core.runner.HookTestStep;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.core.runner.TestStep;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import java.net.URI;
import java.util.Collections;
import java.util.List;

final class PickleStepTestStep
extends TestStep
implements io.cucumber.plugin.event.PickleStepTestStep {
    private final URI uri;
    private final CucumberStep step;
    private final List<HookTestStep> afterStepHookSteps;
    private final List<HookTestStep> beforeStepHookSteps;
    private final PickleStepDefinitionMatch definitionMatch;

    PickleStepTestStep(URI uri, CucumberStep step, PickleStepDefinitionMatch definitionMatch) {
        this(uri, step, Collections.emptyList(), Collections.emptyList(), definitionMatch);
    }

    PickleStepTestStep(URI uri, CucumberStep step, List<HookTestStep> beforeStepHookSteps, List<HookTestStep> afterStepHookSteps, PickleStepDefinitionMatch definitionMatch) {
        super(definitionMatch);
        this.uri = uri;
        this.step = step;
        this.afterStepHookSteps = afterStepHookSteps;
        this.beforeStepHookSteps = beforeStepHookSteps;
        this.definitionMatch = definitionMatch;
    }

    @Override
    boolean run(TestCase testCase, EventBus bus, TestCaseState state, boolean skipSteps) {
        boolean skipNextStep = skipSteps;
        for (HookTestStep before : this.beforeStepHookSteps) {
            skipNextStep |= before.run(testCase, bus, state, skipSteps);
        }
        skipNextStep |= super.run(testCase, bus, state, skipNextStep);
        for (HookTestStep after : this.afterStepHookSteps) {
            skipNextStep |= after.run(testCase, bus, state, skipSteps);
        }
        return skipNextStep;
    }

    List<HookTestStep> getBeforeStepHookSteps() {
        return this.beforeStepHookSteps;
    }

    List<HookTestStep> getAfterStepHookSteps() {
        return this.afterStepHookSteps;
    }

    public CucumberStep getStep() {
        return this.step;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getStepLine() {
        return this.step.getStepLine();
    }

    public String getStepText() {
        return this.step.getText();
    }

    public List<Argument> getDefinitionArgument() {
        return DefinitionArgument.createArguments(this.definitionMatch.getArguments());
    }

    public StepArgument getStepArgument() {
        return this.step.getArgument();
    }

    public String getPattern() {
        return this.definitionMatch.getPattern();
    }
}

