/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.deps.com.google.gson.annotations.SerializedName;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.core.plugin.URLOutputStream;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseEvent;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class TimelineFormatter
implements ConcurrentEventListener {
    private static final String[] TEXT_ASSETS = new String[]{"/io/cucumber/core/plugin/timeline/index.html", "/io/cucumber/core/plugin/timeline/formatter.js", "/io/cucumber/core/plugin/timeline/report.css", "/io/cucumber/core/plugin/timeline/jquery-3.4.1.min.js", "/io/cucumber/core/plugin/timeline/vis.min.css", "/io/cucumber/core/plugin/timeline/vis.min.js", "/io/cucumber/core/plugin/timeline/vis.override.css", "/io/cucumber/core/plugin/timeline/chosen.jquery.min.js", "/io/cucumber/core/plugin/timeline/chosen.min.css", "/io/cucumber/core/plugin/timeline/chosen.override.css", "/io/cucumber/core/plugin/timeline/chosen-sprite.png"};
    private final TestSourcesModel testSources = new TestSourcesModel();
    private final Map<String, TestData> allTests = new HashMap<String, TestData>();
    private final Map<Long, GroupData> allGroups = new HashMap<Long, GroupData>();
    private final URL reportDir;
    private final NiceAppendable reportJs;

    public TimelineFormatter(URL reportDir) {
        this(reportDir, TimelineFormatter.createOutput(reportDir, "report.js"));
    }

    private TimelineFormatter(URL reportDir, NiceAppendable reportJs) {
        this.reportDir = reportDir;
        this.reportJs = reportJs;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::finishReport);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        Thread currentThread = Thread.currentThread();
        Long threadId = currentThread.getId();
        TestData test = new TestData(event, threadId);
        this.allTests.put(this.getId((TestCaseEvent)event), test);
        if (!this.allGroups.containsKey(threadId)) {
            this.allGroups.put(threadId, new GroupData(currentThread));
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        String id = this.getId((TestCaseEvent)event);
        this.allTests.get(id).end(event);
    }

    private void finishReport(TestRunFinished event) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        this.reportJs.append("$(document).ready(function() {");
        this.reportJs.println();
        this.appendAsJsonToJs(gson, this.reportJs, "timelineItems", this.allTests.values());
        this.reportJs.println();
        this.appendAsJsonToJs(gson, this.reportJs, "timelineGroups", new TreeMap<Long, GroupData>(this.allGroups).values());
        this.reportJs.println();
        this.reportJs.append("});");
        this.reportJs.close();
        this.copyReportFiles();
    }

    private void appendAsJsonToJs(Gson gson, NiceAppendable out, String pushTo, Collection<?> content) {
        out.append("CucumberHTML.").append(pushTo).append(".pushArray(");
        gson.toJson(content, (Appendable)out);
        out.append(");");
    }

    private void copyReportFiles() {
        if (this.reportDir == null) {
            return;
        }
        File outputDir = new File(this.reportDir.getPath());
        for (String textAsset : TEXT_ASSETS) {
            InputStream textAssetStream = this.getClass().getResourceAsStream(textAsset);
            if (textAssetStream == null) {
                throw new CucumberException("Couldn't find " + textAsset);
            }
            String fileName = new File(textAsset).getName();
            TimelineFormatter.copyFile(textAssetStream, new File(outputDir, fileName));
            TimelineFormatter.closeQuietly(textAssetStream);
        }
    }

    private static NiceAppendable createOutput(URL dir, String file) {
        File outDir = new File(dir.getPath());
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new CucumberException("Failed to create dir: " + dir.getPath());
        }
        try {
            URLOutputStream out = new URLOutputStream(new URL(dir, file));
            return new NiceAppendable(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private static void copyFile(InputStream source, File dest) throws CucumberException {
        FileOutputStream os = null;
        try {
            int length;
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = source.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            try {
                throw new CucumberException("Unable to write to report file item: ", e);
            }
            catch (Throwable throwable) {
                TimelineFormatter.closeQuietly(os);
                throw throwable;
            }
        }
        TimelineFormatter.closeQuietly(os);
    }

    private static void closeQuietly(Closeable out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getId(TestCaseEvent testCaseEvent) {
        TestCase testCase = testCaseEvent.getTestCase();
        URI uri = testCase.getUri();
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(uri, testCase.getLine());
        return TestSourcesModel.calculateId(astNode);
    }

    static class GroupData {
        @SerializedName(value="id")
        final long id;
        @SerializedName(value="content")
        final String content;

        GroupData(Thread thread) {
            this.id = thread.getId();
            this.content = thread.toString();
        }
    }

    class TestData {
        @SerializedName(value="id")
        final String id;
        @SerializedName(value="feature")
        final String feature;
        @SerializedName(value="scenario")
        final String scenario;
        @SerializedName(value="start")
        final long startTime;
        @SerializedName(value="end")
        long endTime;
        @SerializedName(value="group")
        final long threadId;
        @SerializedName(value="content")
        final String content = "";
        @SerializedName(value="className")
        String className;
        @SerializedName(value="tags")
        final String tags;

        TestData(TestCaseStarted started, Long threadId) {
            this.id = TimelineFormatter.this.getId((TestCaseEvent)started);
            TestCase testCase = started.getTestCase();
            URI uri = testCase.getUri();
            this.feature = TimelineFormatter.this.testSources.getFeatureName(uri);
            this.scenario = testCase.getName();
            this.startTime = started.getInstant().toEpochMilli();
            this.threadId = threadId;
            this.tags = this.buildTagsValue(testCase);
        }

        private String buildTagsValue(TestCase testCase) {
            StringBuilder tags = new StringBuilder();
            for (String tag : testCase.getTags()) {
                tags.append(tag.toLowerCase()).append(",");
            }
            return tags.toString();
        }

        void end(TestCaseFinished event) {
            this.endTime = event.getInstant().toEpochMilli();
            this.className = event.getResult().getStatus().name().toLowerCase(Locale.ROOT);
        }
    }
}

