/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import gherkin.ast.Background;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.Tag;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.plugin.AnsiFormats;
import io.cucumber.core.plugin.Format;
import io.cucumber.core.plugin.Formats;
import io.cucumber.core.plugin.MonochromeFormats;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public final class PrettyFormatter
implements EventListener,
ColorAware {
    private static final String SCENARIO_INDENT = "  ";
    private static final String STEP_INDENT = "    ";
    private static final String EXAMPLES_INDENT = "    ";
    private static final String STEP_SCENARIO_INDENT = "      ";
    private final TestSourcesModel testSources = new TestSourcesModel();
    private final NiceAppendable out;
    private Formats formats;
    private URI currentFeatureFile;
    private TestCase currentTestCase;
    private ScenarioOutline currentScenarioOutline;
    private Examples currentExamples;
    private int locationIndentation;

    public PrettyFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
        this.formats = new AnsiFormats();
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this::handleTestStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(WriteEvent.class, this::handleWrite);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.finishReport());
    }

    public void setMonochrome(boolean monochrome) {
        this.formats = monochrome ? new MonochromeFormats() : new AnsiFormats();
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        this.handleStartOfFeature(event);
        this.handleScenarioOutline(event);
        if (this.testSources.hasBackground(this.currentFeatureFile, event.getTestCase().getLine())) {
            this.printBackground(event.getTestCase());
            this.currentTestCase = event.getTestCase();
        } else {
            this.printScenarioDefinition(event.getTestCase());
        }
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.getTestStep() instanceof PickleStepTestStep && this.isFirstStepAfterBackground((PickleStepTestStep)event.getTestStep())) {
            this.printScenarioDefinition(this.currentTestCase);
            this.currentTestCase = null;
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            this.printStep((PickleStepTestStep)event.getTestStep(), event.getResult());
        }
        this.printError(event.getResult());
    }

    private void handleWrite(WriteEvent event) {
        this.out.println();
        try (BufferedReader lines = new BufferedReader(new StringReader(event.getText()));){
            String line;
            while ((line = lines.readLine()) != null) {
                this.out.println(STEP_SCENARIO_INDENT + line);
            }
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
        this.out.println();
    }

    private void finishReport() {
        this.out.close();
    }

    private void handleStartOfFeature(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.getTestCase().getUri())) {
            if (this.currentFeatureFile != null) {
                this.out.println();
            }
            this.currentFeatureFile = event.getTestCase().getUri();
            this.printFeature(this.currentFeatureFile);
        }
    }

    private void handleScenarioOutline(TestCaseStarted event) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, event.getTestCase().getLine());
        if (TestSourcesModel.isScenarioOutlineScenario(astNode)) {
            ScenarioOutline scenarioOutline = (ScenarioOutline)TestSourcesModel.getScenarioDefinition(astNode);
            if (this.currentScenarioOutline == null || !this.currentScenarioOutline.equals(scenarioOutline)) {
                this.currentScenarioOutline = scenarioOutline;
                this.printScenarioOutline(this.currentScenarioOutline);
            }
            if (this.currentExamples == null || !this.currentExamples.equals(astNode.parent.node)) {
                this.currentExamples = (Examples)astNode.parent.node;
                this.printExamples(this.currentExamples);
            }
        } else {
            this.currentScenarioOutline = null;
            this.currentExamples = null;
        }
    }

    private void printScenarioOutline(ScenarioOutline scenarioOutline) {
        this.out.println();
        this.printTags(scenarioOutline.getTags(), SCENARIO_INDENT);
        this.out.println(SCENARIO_INDENT + this.getScenarioDefinitionText((ScenarioDefinition)scenarioOutline) + " " + this.getLocationText(this.currentFeatureFile, scenarioOutline.getLocation().getLine()));
        this.printDescription(scenarioOutline.getDescription());
        for (Step step : scenarioOutline.getSteps()) {
            this.out.println("    " + this.formats.get("skipped").text(step.getKeyword() + step.getText()));
        }
    }

    private void printExamples(Examples examples) {
        this.out.println();
        this.printTags(examples.getTags(), "    ");
        this.out.println("    " + examples.getKeyword() + ": " + examples.getName());
        this.printDescription(examples.getDescription());
    }

    private void printStep(PickleStepTestStep testStep, Result result) {
        String keyword = this.getStepKeyword(testStep);
        String stepText = testStep.getStepText();
        String locationPadding = this.createPaddingToLocation("    ", keyword + stepText);
        String status = result.getStatus().name().toLowerCase(Locale.ROOT);
        String formattedStepText = this.formatStepText(keyword, stepText, this.formats.get(status), this.formats.get(status + "_arg"), testStep.getDefinitionArgument());
        this.out.println("    " + formattedStepText + locationPadding + this.getLocationText(testStep.getCodeLocation()));
    }

    String formatStepText(String keyword, String stepText, Format textFormat, Format argFormat, List<Argument> arguments) {
        int beginIndex = 0;
        StringBuilder result = new StringBuilder(textFormat.text(keyword));
        for (Argument argument : arguments) {
            if (argument.getValue() != null) {
                int argumentOffset = argument.getStart();
                if (argumentOffset < beginIndex) continue;
                String text = stepText.substring(beginIndex, argumentOffset);
                result.append(textFormat.text(text));
            }
            if (argument.getValue() == null) continue;
            String text = stepText.substring(argument.getStart(), argument.getEnd());
            result.append(argFormat.text(text));
            beginIndex = argument.getEnd();
        }
        if (beginIndex != stepText.length()) {
            String text = stepText.substring(beginIndex);
            result.append(textFormat.text(text));
        }
        return result.toString();
    }

    private String getScenarioDefinitionText(ScenarioDefinition definition) {
        return definition.getKeyword() + ": " + definition.getName();
    }

    private String getLocationText(URI file, int line) {
        String path = TestSourcesModel.relativize(file).getSchemeSpecificPart();
        return this.getLocationText(path + ":" + line);
    }

    private String getLocationText(String location) {
        return this.formats.get("comment").text("# " + location);
    }

    private StringBuffer stepText(PickleStepTestStep testStep) {
        String keyword = this.getStepKeyword(testStep);
        return new StringBuffer(keyword + testStep.getStepText());
    }

    private String getStepKeyword(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (astNode != null) {
            Step step = (Step)astNode.node;
            return step.getKeyword();
        }
        return "";
    }

    private boolean isFirstStepAfterBackground(PickleStepTestStep testStep) {
        return this.currentTestCase != null && !this.isBackgroundStep(testStep);
    }

    private boolean isBackgroundStep(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (astNode != null) {
            return TestSourcesModel.isBackgroundStep(astNode);
        }
        return false;
    }

    private void printFeature(URI path) {
        Feature feature = this.testSources.getFeature(path);
        this.printTags(feature.getTags());
        this.out.println(feature.getKeyword() + ": " + feature.getName());
        this.printDescription(feature.getDescription());
    }

    private void printTags(List<Tag> tags) {
        this.printTags(tags, "");
    }

    private void printTags(List<Tag> tags, String indent) {
        if (!tags.isEmpty()) {
            this.out.println(indent + tags.stream().map(Tag::getName).collect(Collectors.joining(" ")));
        }
    }

    private void printPickleTags(List<String> tags, String indent) {
        if (!tags.isEmpty()) {
            this.out.println(indent + String.join((CharSequence)" ", tags));
        }
    }

    private void printDescription(String description) {
        if (description != null) {
            this.out.println(description);
        }
    }

    private void printBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Background background = TestSourcesModel.getBackgroundForTestCase(astNode);
            String backgroundText = this.getScenarioDefinitionText((ScenarioDefinition)background);
            boolean useBackgroundSteps = true;
            this.calculateLocationIndentation(SCENARIO_INDENT + backgroundText, testCase.getTestSteps(), useBackgroundSteps);
            String locationPadding = this.createPaddingToLocation(SCENARIO_INDENT, backgroundText);
            this.out.println();
            this.out.println(SCENARIO_INDENT + backgroundText + locationPadding + this.getLocationText(this.currentFeatureFile, background.getLocation().getLine()));
            this.printDescription(background.getDescription());
        }
    }

    private void printScenarioDefinition(TestCase testCase) {
        ScenarioDefinition scenarioDefinition = this.testSources.getScenarioDefinition(this.currentFeatureFile, testCase.getLine());
        String definitionText = scenarioDefinition.getKeyword() + ": " + testCase.getName();
        this.calculateLocationIndentation(SCENARIO_INDENT + definitionText, testCase.getTestSteps());
        String locationPadding = this.createPaddingToLocation(SCENARIO_INDENT, definitionText);
        this.out.println();
        this.printPickleTags(testCase.getTags(), SCENARIO_INDENT);
        this.out.println(SCENARIO_INDENT + definitionText + locationPadding + this.getLocationText(this.currentFeatureFile, testCase.getLine()));
        this.printDescription(scenarioDefinition.getDescription());
    }

    private void printError(Result result) {
        if (result.getError() != null) {
            String name = result.getStatus().name().toLowerCase(Locale.ROOT);
            this.out.println(STEP_SCENARIO_INDENT + this.formats.get(name).text(PrettyFormatter.printStackTrace(result.getError())));
        }
    }

    private void calculateLocationIndentation(String definitionText, List<TestStep> testSteps) {
        boolean useBackgroundSteps = false;
        this.calculateLocationIndentation(definitionText, testSteps, useBackgroundSteps);
    }

    private void calculateLocationIndentation(String definitionText, List<TestStep> testSteps, boolean useBackgroundSteps) {
        int maxTextLength = definitionText.length();
        for (TestStep step : testSteps) {
            PickleStepTestStep testStep;
            if (!(step instanceof PickleStepTestStep) || this.isBackgroundStep(testStep = (PickleStepTestStep)step) != useBackgroundSteps) continue;
            StringBuffer stepText = this.stepText(testStep);
            maxTextLength = Math.max(maxTextLength, "    ".length() + stepText.length());
        }
        this.locationIndentation = maxTextLength + 1;
    }

    private String createPaddingToLocation(String indent, String text) {
        StringBuilder padding = new StringBuilder();
        for (int i = indent.length() + text.length(); i < this.locationIndentation; ++i) {
            padding.append(' ');
        }
        return padding.toString();
    }

    private static String printStackTrace(Throwable error) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        error.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

