/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.StepDefinedEvent;
import io.cucumber.plugin.event.TestCaseEvent;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

final class CanonicalEventOrder
implements Comparator<Event> {
    private static final FixedEventOrderComparator fixedOrder = new FixedEventOrderComparator();
    private static final TestCaseEventComparator testCaseOrder = new TestCaseEventComparator();

    CanonicalEventOrder() {
    }

    @Override
    public int compare(Event a, Event b) {
        int fixedOrder = CanonicalEventOrder.fixedOrder.compare(a, b);
        if (fixedOrder != 0) {
            return fixedOrder;
        }
        if (!(a instanceof TestCaseEvent) || !(b instanceof TestCaseEvent)) {
            return fixedOrder;
        }
        return testCaseOrder.compare((TestCaseEvent)a, (TestCaseEvent)b);
    }

    private static final class TestCaseEventComparator
    implements Comparator<TestCaseEvent> {
        private TestCaseEventComparator() {
        }

        @Override
        public int compare(TestCaseEvent a, TestCaseEvent b) {
            int uri = a.getTestCase().getUri().compareTo(b.getTestCase().getUri());
            if (uri != 0) {
                return uri;
            }
            int line = Integer.compare(a.getTestCase().getLine(), b.getTestCase().getLine());
            if (line != 0) {
                return line;
            }
            return a.getInstant().compareTo(b.getInstant());
        }
    }

    private static final class FixedEventOrderComparator
    implements Comparator<Event> {
        private final List<Class<? extends Event>> fixedOrder = Arrays.asList(TestRunStarted.class, TestSourceRead.class, SnippetsSuggestedEvent.class, StepDefinedEvent.class, TestCaseEvent.class, TestRunFinished.class);

        private FixedEventOrderComparator() {
        }

        @Override
        public int compare(Event a, Event b) {
            return Integer.compare(this.requireInFixOrder(a.getClass()), this.requireInFixOrder(b.getClass()));
        }

        private int requireInFixOrder(Class<? extends Event> o) {
            int index = this.findInFixedOrder(o);
            if (index < 0) {
                throw new IllegalStateException(o + "was not in " + this.fixedOrder);
            }
            return index;
        }

        private int findInFixedOrder(Class<? extends Event> o) {
            for (int i = 0; i < this.fixedOrder.size(); ++i) {
                if (!this.fixedOrder.get(i).isAssignableFrom(o)) continue;
                return i;
            }
            return -1;
        }
    }
}

