/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.filter;

import io.cucumber.core.feature.CucumberPickle;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

final class LinePredicate
implements Predicate<CucumberPickle> {
    private final Map<URI, ? extends Collection<Integer>> lineFilters;

    LinePredicate(Map<URI, ? extends Collection<Integer>> lineFilters) {
        this.lineFilters = lineFilters;
    }

    @Override
    public boolean test(CucumberPickle pickle) {
        URI picklePath = pickle.getUri();
        if (!this.lineFilters.containsKey(picklePath)) {
            return true;
        }
        for (Integer line : this.lineFilters.get(picklePath)) {
            if (line.intValue() != pickle.getLocation().getLine() && line.intValue() != pickle.getScenarioLocation().getLine()) continue;
            return true;
        }
        return false;
    }
}

