/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.filter;

import io.cucumber.core.feature.CucumberPickle;
import io.cucumber.core.filter.LinePredicate;
import io.cucumber.core.filter.NamePredicate;
import io.cucumber.core.filter.Options;
import io.cucumber.core.filter.TagPredicate;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class Filters
implements Predicate<CucumberPickle> {
    private Predicate<CucumberPickle> filter = t -> true;

    public Filters(Options options) {
        Map<URI, Set<Integer>> lineFilters;
        List<Pattern> nameFilters;
        List<String> tagExpressions = options.getTagExpressions();
        if (!tagExpressions.isEmpty()) {
            this.filter = this.filter.and(new TagPredicate(tagExpressions));
        }
        if (!(nameFilters = options.getNameFilters()).isEmpty()) {
            this.filter = this.filter.and(new NamePredicate(nameFilters));
        }
        if (!(lineFilters = options.getLineFilters()).isEmpty()) {
            this.filter = this.filter.and(new LinePredicate(lineFilters));
        }
    }

    @Override
    public boolean test(CucumberPickle pickle) {
        return this.filter.test(pickle);
    }
}

