/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import gherkin.AstBuilder;
import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.TokenMatcher;
import gherkin.ast.GherkinDocument;
import gherkin.pickles.Compiler;
import gherkin.pickles.Pickle;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.CucumberFeature;
import io.cucumber.core.feature.CucumberPickle;
import io.cucumber.core.feature.Encoding;
import io.cucumber.core.resource.Resource;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FeatureParser {
    private FeatureParser() {
    }

    public static CucumberFeature parseResource(Resource resource) {
        Objects.requireNonNull(resource);
        URI uri = resource.getUri();
        String source = FeatureParser.read(resource);
        try {
            Parser parser = new Parser((Parser.Builder)new AstBuilder());
            TokenMatcher matcher = new TokenMatcher();
            GherkinDocument gherkinDocument = (GherkinDocument)parser.parse(source, (Parser.ITokenMatcher)matcher);
            GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
            List<CucumberPickle> pickles = FeatureParser.compilePickles(gherkinDocument, dialectProvider, resource);
            return new CucumberFeature(gherkinDocument, uri, source, pickles);
        }
        catch (ParserException e) {
            throw new CucumberException("Failed to parse resource at: " + uri.toString(), e);
        }
    }

    private static String read(Resource resource) {
        try {
            return Encoding.readFile(resource);
        }
        catch (IOException e) {
            throw new CucumberException("Failed to read resource:" + resource.getUri(), e);
        }
    }

    private static List<CucumberPickle> compilePickles(GherkinDocument document, GherkinDialectProvider dialectProvider, Resource resource) {
        if (document.getFeature() == null) {
            return Collections.emptyList();
        }
        String language = document.getFeature().getLanguage();
        GherkinDialect dialect = dialectProvider.getDialect(language, null);
        return new Compiler().compile(document).stream().map(pickle -> new CucumberPickle((Pickle)pickle, resource.getUri(), document, dialect)).collect(Collectors.toList());
    }
}

