/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;
import io.cucumber.core.feature.Argument;
import java.util.AbstractList;
import java.util.List;

public final class DataTableArgument
implements Argument,
io.cucumber.plugin.event.DataTableArgument {
    private final CellView cells;
    private final int line;

    DataTableArgument(PickleTable table) {
        this.cells = new CellView(table);
        this.line = table.getLocation().getLine();
    }

    public List<List<String>> cells() {
        return this.cells;
    }

    public int getLine() {
        return this.line;
    }

    private static class CellView
    extends AbstractList<List<String>> {
        private final PickleTable table;

        CellView(PickleTable table) {
            this.table = table;
        }

        @Override
        public List<String> get(final int row) {
            return new AbstractList<String>(){

                @Override
                public String get(int column) {
                    return ((PickleCell)((PickleRow)table.getRows().get(row)).getCells().get(column)).getValue();
                }

                @Override
                public int size() {
                    return ((PickleRow)table.getRows().get(row)).getCells().size();
                }
            };
        }

        @Override
        public int size() {
            return this.table.getRows().size();
        }
    }
}

