/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import gherkin.GherkinDialect;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Step;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import io.cucumber.core.feature.Argument;
import io.cucumber.core.feature.DataTableArgument;
import io.cucumber.core.feature.DocStringArgument;
import io.cucumber.core.feature.StepType;

public final class CucumberStep
implements io.cucumber.plugin.event.CucumberStep {
    private final PickleStep step;
    private final Argument argument;
    private final String keyWord;
    private final StepType stepType;
    private final String previousGwtKeyWord;

    CucumberStep(PickleStep step, GherkinDocument document, GherkinDialect dialect, String previousGwtKeyWord) {
        this.step = step;
        this.argument = this.extractArgument(step);
        this.keyWord = this.extractKeyWord(document);
        this.stepType = this.extractKeyWordType(this.keyWord, dialect);
        this.previousGwtKeyWord = previousGwtKeyWord;
    }

    private String extractKeyWord(GherkinDocument document) {
        return document.getFeature().getChildren().stream().flatMap(scenarioDefinition -> scenarioDefinition.getSteps().stream()).filter(step -> step.getLocation().getLine() == this.getStepLine()).findFirst().map(Step::getKeyword).orElseThrow(() -> new IllegalStateException("GherkinDocument did not contain PickleStep"));
    }

    private StepType extractKeyWordType(String keyWord, GherkinDialect dialect) {
        if (StepType.isAstrix(keyWord)) {
            return StepType.OTHER;
        }
        if (dialect.getGivenKeywords().contains(keyWord)) {
            return StepType.GIVEN;
        }
        if (dialect.getWhenKeywords().contains(keyWord)) {
            return StepType.WHEN;
        }
        if (dialect.getThenKeywords().contains(keyWord)) {
            return StepType.THEN;
        }
        if (dialect.getAndKeywords().contains(keyWord)) {
            return StepType.AND;
        }
        if (dialect.getButKeywords().contains(keyWord)) {
            return StepType.BUT;
        }
        throw new IllegalStateException("Keyword " + keyWord + " was neither given, when, then, and, but nor *");
    }

    private Argument extractArgument(PickleStep pickleStep) {
        if (pickleStep.getArgument().isEmpty()) {
            return null;
        }
        gherkin.pickles.Argument argument = (gherkin.pickles.Argument)pickleStep.getArgument().get(0);
        if (argument instanceof PickleString) {
            PickleString docString = (PickleString)argument;
            return new DocStringArgument(docString);
        }
        if (argument instanceof PickleTable) {
            PickleTable table = (PickleTable)argument;
            return new DataTableArgument(table);
        }
        return null;
    }

    public int getStepLine() {
        int last = this.step.getLocations().size() - 1;
        return ((PickleLocation)this.step.getLocations().get(last)).getLine();
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public StepType getStepType() {
        return this.stepType;
    }

    public String getPreviousGivenWhenThenKeyWord() {
        return this.previousGwtKeyWord;
    }

    public String getText() {
        return this.step.getText();
    }
}

