/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import gherkin.GherkinDialect;
import gherkin.ast.GherkinDocument;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleTag;
import io.cucumber.core.feature.CucumberLocation;
import io.cucumber.core.feature.CucumberStep;
import io.cucumber.core.feature.Located;
import io.cucumber.core.feature.StepType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class CucumberPickle
implements Located {
    private final Pickle pickle;
    private final List<CucumberStep> steps;
    private final URI uri;

    CucumberPickle(Pickle pickle, URI uri, GherkinDocument document, GherkinDialect dialect) {
        this.pickle = pickle;
        this.uri = uri;
        this.steps = CucumberPickle.createCucumberSteps(pickle, document, dialect);
    }

    private static List<CucumberStep> createCucumberSteps(Pickle pickle, GherkinDocument document, GherkinDialect dialect) {
        ArrayList<CucumberStep> list = new ArrayList<CucumberStep>();
        String previousGivenWhenThen = dialect.getGivenKeywords().stream().filter(s -> !StepType.isAstrix(s)).findFirst().orElseThrow(() -> new IllegalStateException("No Given keyword for dialect: " + dialect.getName()));
        for (PickleStep step : pickle.getSteps()) {
            CucumberStep cucumberStep = new CucumberStep(step, document, dialect, previousGivenWhenThen);
            if (cucumberStep.getStepType().isGivenWhenThen()) {
                previousGivenWhenThen = cucumberStep.getKeyWord();
            }
            list.add(cucumberStep);
        }
        return list;
    }

    public String getLanguage() {
        return this.pickle.getLanguage();
    }

    @Override
    public CucumberLocation getLocation() {
        return CucumberLocation.from((PickleLocation)this.pickle.getLocations().get(0));
    }

    public String getName() {
        return this.pickle.getName();
    }

    public CucumberLocation getScenarioLocation() {
        List stepLocations = this.pickle.getLocations();
        PickleLocation scenarioLocation = (PickleLocation)stepLocations.get(stepLocations.size() - 1);
        return CucumberLocation.from(scenarioLocation);
    }

    public List<CucumberStep> getSteps() {
        return this.steps;
    }

    public List<String> getTags() {
        return this.pickle.getTags().stream().map(PickleTag::getName).collect(Collectors.toList());
    }

    public URI getUri() {
        return this.uri;
    }
}

