/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import gherkin.ast.Location;
import gherkin.pickles.PickleLocation;
import java.util.Objects;

public final class CucumberLocation {
    private final int line;
    private final int column;

    private CucumberLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    static CucumberLocation from(Location location) {
        return new CucumberLocation(location.getLine(), location.getColumn());
    }

    static CucumberLocation from(PickleLocation location) {
        return new CucumberLocation(location.getLine(), location.getColumn());
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CucumberLocation that = (CucumberLocation)o;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }
}

