/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import gherkin.ast.GherkinDocument;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import io.cucumber.core.feature.Container;
import io.cucumber.core.feature.CucumberLocation;
import io.cucumber.core.feature.CucumberPickle;
import io.cucumber.core.feature.CucumberScenario;
import io.cucumber.core.feature.CucumberScenarioDefinition;
import io.cucumber.core.feature.CucumberScenarioOutline;
import io.cucumber.core.feature.Located;
import io.cucumber.core.feature.Named;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class CucumberFeature
implements Located,
Named,
Container<CucumberScenarioDefinition> {
    private final URI uri;
    private final List<CucumberPickle> pickles;
    private final GherkinDocument gherkinDocument;
    private final String gherkinSource;

    CucumberFeature(GherkinDocument gherkinDocument, URI uri, String gherkinSource, List<CucumberPickle> pickles) {
        this.gherkinDocument = gherkinDocument;
        this.uri = uri;
        this.gherkinSource = gherkinSource;
        this.pickles = pickles;
    }

    @Override
    public Stream<CucumberScenarioDefinition> children() {
        return this.gherkinDocument.getFeature().getChildren().stream().map(scenarioDefinition -> {
            if (scenarioDefinition instanceof ScenarioOutline) {
                ScenarioOutline scenarioOutline = (ScenarioOutline)scenarioDefinition;
                return new CucumberScenarioOutline(scenarioOutline);
            }
            return new CucumberScenario((ScenarioDefinition)scenarioDefinition);
        });
    }

    public String getKeyword() {
        return this.gherkinDocument.getFeature().getKeyword();
    }

    @Override
    public CucumberLocation getLocation() {
        return CucumberLocation.from(this.gherkinDocument.getFeature().getLocation());
    }

    public List<CucumberPickle> getPickles() {
        return this.pickles;
    }

    @Override
    public String getKeyWord() {
        return this.gherkinDocument.getFeature().getKeyword();
    }

    @Override
    public String getName() {
        return this.gherkinDocument.getFeature().getName();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSource() {
        return this.gherkinSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CucumberFeature that = (CucumberFeature)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public Optional<CucumberPickle> getPickleAt(CucumberLocation line) {
        return this.pickles.stream().filter(cucumberPickle -> cucumberPickle.getLocation().equals(line)).findFirst();
    }
}

