/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.cli;

import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.runtime.Runtime;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class Main {
    public static void main(String ... argv) {
        byte exitStatus = Main.run(argv, Thread.currentThread().getContextClassLoader());
        System.exit(exitStatus);
    }

    public static byte run(String[] argv, ClassLoader classLoader) {
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(propertiesFileOptions);
        RuntimeOptions systemOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).build(environmentOptions);
        RuntimeOptions runtimeOptions = new CommandlineOptionsParser().parse(argv).addDefaultFormatterIfAbsent().addDefaultSummaryPrinterIfAbsent().build(systemOptions);
        Runtime runtime = Runtime.builder().withRuntimeOptions(runtimeOptions).withClassLoader(() -> classLoader).build();
        runtime.run();
        return runtime.exitStatus();
    }
}

