/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.PickleStepTestStep;
import cucumber.api.Plugin;
import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestStepFinished;
import cucumber.api.formatter.NiceAppendable;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class UsageFormatter
implements Plugin,
EventListener {
    private static final BigDecimal NANOS_PER_SECOND = BigDecimal.valueOf(1000000000L);
    final Map<String, List<StepContainer>> usageMap = new LinkedHashMap<String, List<StepContainer>>();
    private final NiceAppendable out;
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            UsageFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            UsageFormatter.this.finishReport();
        }
    };

    public UsageFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof PickleStepTestStep && event.result.is(Result.Type.PASSED)) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
            this.addUsageEntry(event.result, testStep);
        }
    }

    void finishReport() {
        ArrayList<StepDefContainer> stepDefContainers = new ArrayList<StepDefContainer>();
        for (Map.Entry<String, List<StepContainer>> usageEntry : this.usageMap.entrySet()) {
            StepDefContainer stepDefContainer = new StepDefContainer(usageEntry.getKey(), this.createStepContainers(usageEntry.getValue()));
            stepDefContainers.add(stepDefContainer);
        }
        this.gson().toJson(stepDefContainers, (Appendable)this.out);
        this.out.close();
    }

    private List<StepContainer> createStepContainers(List<StepContainer> stepContainers) {
        for (StepContainer stepContainer : stepContainers) {
            stepContainer.putAllAggregatedDurations(this.createAggregatedDurations(stepContainer));
        }
        return stepContainers;
    }

    private Map<String, BigDecimal> createAggregatedDurations(StepContainer stepContainer) {
        LinkedHashMap<String, BigDecimal> aggregatedResults = new LinkedHashMap<String, BigDecimal>();
        List<BigDecimal> rawDurations = this.getRawDurations(stepContainer.getDurations());
        BigDecimal average = this.calculateAverage(rawDurations);
        aggregatedResults.put("average", average);
        BigDecimal median = this.calculateMedian(rawDurations);
        aggregatedResults.put("median", median);
        return aggregatedResults;
    }

    private BigDecimal toSeconds(Long nanoSeconds) {
        return BigDecimal.valueOf(nanoSeconds).divide(NANOS_PER_SECOND);
    }

    private List<BigDecimal> getRawDurations(List<StepDuration> stepDurations) {
        ArrayList<BigDecimal> rawDurations = new ArrayList<BigDecimal>();
        for (StepDuration stepDuration : stepDurations) {
            rawDurations.add(stepDuration.duration);
        }
        return rawDurations;
    }

    private Gson gson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    private void addUsageEntry(Result result, PickleStepTestStep testStep) {
        List<StepContainer> stepContainers = this.findOrCreateUsageEntry(testStep.getPattern());
        StepContainer stepContainer = this.findOrCreateStepContainer(testStep.getStepText(), stepContainers);
        StepDuration stepDuration = this.createStepDuration(result.getDuration(), testStep.getStepLocation());
        stepContainer.getDurations().add(stepDuration);
    }

    private List<StepContainer> findOrCreateUsageEntry(String stepDefinition) {
        List<StepContainer> stepContainers = this.usageMap.get(stepDefinition);
        if (stepContainers == null) {
            stepContainers = new ArrayList<StepContainer>();
            this.usageMap.put(stepDefinition, stepContainers);
        }
        return stepContainers;
    }

    private StepDuration createStepDuration(Long duration, String location) {
        StepDuration stepDuration = new StepDuration(this.toSeconds(duration), location);
        return stepDuration;
    }

    private StepContainer findOrCreateStepContainer(String stepNameWithArgs, List<StepContainer> stepContainers) {
        for (StepContainer container : stepContainers) {
            if (!stepNameWithArgs.equals(container.getName())) continue;
            return container;
        }
        StepContainer stepContainer = new StepContainer(stepNameWithArgs);
        stepContainers.add(stepContainer);
        return stepContainer;
    }

    BigDecimal calculateAverage(List<BigDecimal> durationEntries) {
        if (durationEntries.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = BigDecimal.valueOf(0L);
        for (BigDecimal duration : durationEntries) {
            sum = sum.add(duration);
        }
        return sum.divide(BigDecimal.valueOf(durationEntries.size()), 9, RoundingMode.HALF_UP);
    }

    BigDecimal calculateMedian(List<BigDecimal> durationEntries) {
        if (durationEntries.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Collections.sort(durationEntries);
        int middle = durationEntries.size() / 2;
        if (durationEntries.size() % 2 == 1) {
            return durationEntries.get(middle);
        }
        BigDecimal total = durationEntries.get(middle - 1).add(durationEntries.get(middle));
        return total.divide(BigDecimal.valueOf(2.0), 9, RoundingMode.HALF_UP);
    }

    static class StepDuration {
        private final BigDecimal duration;
        private final String location;

        StepDuration(BigDecimal duration, String location) {
            this.duration = duration;
            this.location = location;
        }

        public BigDecimal getDuration() {
            return this.duration;
        }

        public String getLocation() {
            return this.location;
        }
    }

    static class StepContainer {
        private final String name;
        private final Map<String, BigDecimal> aggregatedDurations = new HashMap<String, BigDecimal>();
        private final List<StepDuration> durations = new ArrayList<StepDuration>();

        StepContainer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void putAllAggregatedDurations(Map<String, BigDecimal> aggregatedDurations) {
            this.aggregatedDurations.putAll(aggregatedDurations);
        }

        public Map<String, BigDecimal> getAggregatedDurations() {
            return this.aggregatedDurations;
        }

        List<StepDuration> getDurations() {
            return this.durations;
        }
    }

    static class StepDefContainer {
        private final String source;
        private final List<StepContainer> steps;

        StepDefContainer(String source, List<StepContainer> steps) {
            this.source = source;
            this.steps = steps;
        }

        public String getSource() {
            return this.source;
        }

        public List<StepContainer> getSteps() {
            return this.steps;
        }
    }
}

