/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.Result;
import cucumber.api.SummaryPrinter;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.StepDefinedEvent;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestStepFinished;
import cucumber.api.formatter.ColorAware;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.formatter.AnsiFormats;
import cucumber.runtime.formatter.Format;
import cucumber.runtime.formatter.Formats;
import cucumber.runtime.formatter.MonochromeFormats;
import java.util.Map;
import java.util.TreeMap;

public class UnusedStepsSummaryPrinter
implements ColorAware,
EventListener,
SummaryPrinter {
    private EventHandler<StepDefinedEvent> stepDefinedHandler = new EventHandler<StepDefinedEvent>(){

        @Override
        public void receive(StepDefinedEvent event) {
            UnusedStepsSummaryPrinter.this.unusedSteps.put(event.stepDefinition.getLocation(false), event.stepDefinition.getPattern());
        }
    };
    private EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            String codeLocation = event.testStep.getCodeLocation();
            if (codeLocation != null) {
                UnusedStepsSummaryPrinter.this.unusedSteps.remove(codeLocation);
            }
        }
    };
    private EventHandler<TestRunFinished> testRunFinishedhandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            if (UnusedStepsSummaryPrinter.this.unusedSteps.isEmpty()) {
                return;
            }
            Format format = UnusedStepsSummaryPrinter.this.formats.get(Result.Type.UNUSED.lowerCaseName());
            UnusedStepsSummaryPrinter.this.out.println(format.text(UnusedStepsSummaryPrinter.this.unusedSteps.size() + " Unused steps:"));
            for (Map.Entry entry : UnusedStepsSummaryPrinter.this.unusedSteps.entrySet()) {
                String location = (String)entry.getKey();
                String pattern = (String)entry.getValue();
                UnusedStepsSummaryPrinter.this.out.println(format.text(location) + " # " + pattern);
            }
        }
    };
    private final Map<String, String> unusedSteps = new TreeMap<String, String>();
    private final NiceAppendable out;
    private Formats formats = new MonochromeFormats();

    public UnusedStepsSummaryPrinter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(StepDefinedEvent.class, this.stepDefinedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.testRunFinishedhandler);
    }

    @Override
    public void setMonochrome(boolean monochrome) {
        this.formats = monochrome ? new MonochromeFormats() : new AnsiFormats();
    }
}

