/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.FeatureSupplier;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import cucumber.util.FixJava;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.FeatureOptions;
import java.net.URI;
import java.util.List;

public class FeaturePathFeatureSupplier
implements FeatureSupplier {
    private static final Logger log = LoggerFactory.getLogger(FeaturePathFeatureSupplier.class);
    private final FeatureLoader featureLoader;
    private final FeatureOptions featureOptions;

    public FeaturePathFeatureSupplier(FeatureLoader featureLoader, FeatureOptions featureOptions) {
        this.featureLoader = featureLoader;
        this.featureOptions = featureOptions;
    }

    @Override
    public List<CucumberFeature> get() {
        List<URI> featurePaths = this.featureOptions.getFeaturePaths();
        log.debug("Loading features from " + FixJava.join(featurePaths, ", "));
        List<CucumberFeature> cucumberFeatures = this.featureLoader.load(featurePaths);
        if (cucumberFeatures.isEmpty()) {
            if (featurePaths.isEmpty()) {
                log.warn("Got no path to feature directory or feature file");
            } else {
                log.warn("No features found at " + FixJava.join(featurePaths, ", "));
            }
        }
        return cucumberFeatures;
    }
}

