/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.filter;

import cucumber.runtime.filter.PicklePredicate;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

class LinePredicate
implements PicklePredicate {
    private Map<URI, ? extends Collection<Integer>> lineFilters;

    LinePredicate(Map<URI, ? extends Collection<Integer>> lineFilters) {
        this.lineFilters = lineFilters;
    }

    @Override
    public boolean apply(PickleEvent pickleEvent) {
        URI picklePath = URI.create(pickleEvent.uri);
        if (!this.lineFilters.containsKey(picklePath)) {
            return true;
        }
        for (Integer line : this.lineFilters.get(picklePath)) {
            for (PickleLocation location : pickleEvent.pickle.getLocations()) {
                if (line.intValue() != location.getLine()) continue;
                return true;
            }
        }
        return false;
    }
}

