/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.StepDefinedEvent;
import cucumber.runner.AmbiguousStepDefinitionsException;
import cucumber.runner.EventBus;
import cucumber.runner.HookComparator;
import cucumber.runner.PickleStepDefinitionMatch;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.ScenarioScoped;
import cucumber.runtime.StepDefinition;
import gherkin.pickles.PickleStep;
import io.cucumber.stepexpression.Argument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class Glue
implements cucumber.runtime.Glue {
    final Map<String, StepDefinition> stepDefinitionsByPattern = new TreeMap<String, StepDefinition>();
    final Map<String, StepDefinition> stepDefinitionsByStepText = new HashMap<String, StepDefinition>();
    final List<HookDefinition> beforeHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> beforeStepHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> afterHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> afterStepHooks = new ArrayList<HookDefinition>();
    private final EventBus bus;

    public Glue(EventBus bus) {
        this.bus = bus;
    }

    @Override
    public void addStepDefinition(StepDefinition stepDefinition) {
        StepDefinition previous = this.stepDefinitionsByPattern.get(stepDefinition.getPattern());
        if (previous != null) {
            throw new DuplicateStepDefinitionException(previous, stepDefinition);
        }
        this.stepDefinitionsByPattern.put(stepDefinition.getPattern(), stepDefinition);
        this.bus.send(new StepDefinedEvent(this.bus.getTime(), this.bus.getTimeMillis(), stepDefinition));
    }

    @Override
    public void addBeforeHook(HookDefinition hookDefinition) {
        this.beforeHooks.add(hookDefinition);
        Collections.sort(this.beforeHooks, new HookComparator(true));
    }

    @Override
    public void addBeforeStepHook(HookDefinition hookDefinition) {
        this.beforeStepHooks.add(hookDefinition);
        Collections.sort(this.beforeStepHooks, new HookComparator(true));
    }

    @Override
    public void addAfterHook(HookDefinition hookDefinition) {
        this.afterHooks.add(hookDefinition);
        Collections.sort(this.afterHooks, new HookComparator(false));
    }

    @Override
    public void addAfterStepHook(HookDefinition hookDefinition) {
        this.afterStepHooks.add(hookDefinition);
        Collections.sort(this.afterStepHooks, new HookComparator(false));
    }

    List<HookDefinition> getBeforeHooks() {
        return this.beforeHooks;
    }

    List<HookDefinition> getBeforeStepHooks() {
        return this.beforeStepHooks;
    }

    List<HookDefinition> getAfterHooks() {
        return this.afterHooks;
    }

    List<HookDefinition> getAfterStepHooks() {
        return this.afterStepHooks;
    }

    PickleStepDefinitionMatch stepDefinitionMatch(String featurePath, PickleStep step) {
        String stepText = step.getText();
        StepDefinition stepDefinition = this.stepDefinitionsByStepText.get(stepText);
        if (stepDefinition != null) {
            List<Argument> arguments = stepDefinition.matchedArguments(step);
            return new PickleStepDefinitionMatch(arguments, stepDefinition, featurePath, step);
        }
        List<PickleStepDefinitionMatch> matches = this.stepDefinitionMatches(featurePath, step);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new AmbiguousStepDefinitionsException(step, matches);
        }
        PickleStepDefinitionMatch match = matches.get(0);
        this.stepDefinitionsByStepText.put(stepText, match.getStepDefinition());
        return match;
    }

    private List<PickleStepDefinitionMatch> stepDefinitionMatches(String featurePath, PickleStep step) {
        ArrayList<PickleStepDefinitionMatch> result = new ArrayList<PickleStepDefinitionMatch>();
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            List<Argument> arguments = stepDefinition.matchedArguments(step);
            if (arguments == null) continue;
            result.add(new PickleStepDefinitionMatch(arguments, stepDefinition, featurePath, step));
        }
        return result;
    }

    void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            stepDefinitionReporter.stepDefinition(stepDefinition);
        }
    }

    @Override
    public void removeScenarioScopedGlue() {
        this.removeScenarioScopedHooks(this.beforeHooks);
        this.removeScenarioScopedHooks(this.beforeStepHooks);
        this.removeScenarioScopedHooks(this.afterHooks);
        this.removeScenarioScopedHooks(this.afterStepHooks);
        this.removeScenariosScopedStepDefinitions(this.stepDefinitionsByPattern);
        this.removeScenariosScopedStepDefinitions(this.stepDefinitionsByStepText);
    }

    private void removeScenarioScopedHooks(List<HookDefinition> beforeHooks) {
        Iterator<HookDefinition> hookIterator = beforeHooks.iterator();
        while (hookIterator.hasNext()) {
            HookDefinition hook = hookIterator.next();
            if (hook instanceof ScenarioScoped) {
                ScenarioScoped scenarioScopedHookDefinition = (ScenarioScoped)((Object)hook);
                scenarioScopedHookDefinition.disposeScenarioScope();
            }
            if (!hook.isScenarioScoped()) continue;
            hookIterator.remove();
        }
    }

    private void removeScenariosScopedStepDefinitions(Map<String, StepDefinition> stepDefinitions) {
        Iterator<Map.Entry<String, StepDefinition>> stepDefinitionIterator = stepDefinitions.entrySet().iterator();
        while (stepDefinitionIterator.hasNext()) {
            StepDefinition stepDefinition = stepDefinitionIterator.next().getValue();
            if (stepDefinition instanceof ScenarioScoped) {
                ScenarioScoped scenarioScopedStepDefinition = (ScenarioScoped)((Object)stepDefinition);
                scenarioScopedStepDefinition.disposeScenarioScope();
            }
            if (!stepDefinition.isScenarioScoped()) continue;
            stepDefinitionIterator.remove();
        }
    }
}

