/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.io.Resource;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureParser;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureBuilder {
    private final Logger log = LoggerFactory.getLogger(FeatureBuilder.class);
    private final Map<String, CucumberFeature> sourceToFeature = new HashMap<String, CucumberFeature>();

    public List<CucumberFeature> build() {
        ArrayList<CucumberFeature> cucumberFeatures = new ArrayList<CucumberFeature>(this.sourceToFeature.values());
        Collections.sort(cucumberFeatures, new CucumberFeature.CucumberFeatureUriComparator());
        return cucumberFeatures;
    }

    public void parse(Resource resource) {
        CucumberFeature parsedFeature = FeatureParser.parseResource(resource);
        CucumberFeature existingFeature = this.sourceToFeature.get(parsedFeature.getSource());
        if (existingFeature != null) {
            this.log.warn("Duplicate feature ignored. " + parsedFeature.getUri() + " was identical to " + existingFeature.getUri());
            return;
        }
        this.sourceToFeature.put(parsedFeature.getSource(), parsedFeature);
    }
}

