/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.Result;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.WriteEvent;
import cucumber.runner.EventBus;
import cucumber.runner.TestCase;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class Scenario
implements cucumber.api.Scenario {
    private final List<Result> stepResults = new ArrayList<Result>();
    private final EventBus bus;
    private final TestCase testCase;

    Scenario(EventBus bus, TestCase testCase) {
        this.bus = bus;
        this.testCase = testCase;
    }

    public void add(Result result) {
        this.stepResults.add(result);
    }

    @Override
    public Collection<String> getSourceTagNames() {
        HashSet<String> result = new HashSet<String>();
        for (PickleTag tag : this.testCase.getTags()) {
            result.add(tag.getName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public Result.Type getStatus() {
        if (this.stepResults.isEmpty()) {
            return Result.Type.UNDEFINED;
        }
        return Collections.max(this.stepResults, Result.SEVERITY).getStatus();
    }

    @Override
    public boolean isFailed() {
        return this.getStatus() == Result.Type.FAILED;
    }

    @Override
    public void embed(byte[] data, String mimeType) {
        if (this.bus != null) {
            this.bus.send(new EmbedEvent(this.bus.getTime(), this.bus.getTimeMillis(), this.testCase, data, mimeType));
        }
    }

    @Override
    public void write(String text) {
        if (this.bus != null) {
            this.bus.send(new WriteEvent(this.bus.getTime(), this.bus.getTimeMillis(), this.testCase, text));
        }
    }

    @Override
    public String getName() {
        return this.testCase.getName();
    }

    @Override
    public String getId() {
        return this.testCase.getUri() + ":" + this.testCase.getLine();
    }

    @Override
    public String getUri() {
        return this.testCase.getUri();
    }

    @Override
    public List<Integer> getLines() {
        return this.testCase.getLines();
    }

    public Throwable getError() {
        if (this.stepResults.isEmpty()) {
            return null;
        }
        return Collections.max(this.stepResults, Result.SEVERITY).getError();
    }
}

