/*
 * Decompiled with CFR 0.152.
 */
package cucumber.util;

import cucumber.runtime.io.Resource;
import cucumber.util.FixJava;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Encoding {
    private static final Pattern COMMENT_OR_EMPTY_LINE_PATTERN = Pattern.compile("^\\s*#|^\\s*$");
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^\\s*#\\s*encoding\\s*:\\s*([0-9a-zA-Z\\-]+)", 2);
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String readFile(Resource resource) throws RuntimeException, IOException {
        String source = FixJava.readReader(new InputStreamReader(resource.getInputStream(), DEFAULT_ENCODING));
        String enc = Encoding.encoding(source);
        if (!enc.equals(DEFAULT_ENCODING)) {
            source = FixJava.readReader(new InputStreamReader(resource.getInputStream(), enc));
        }
        return source;
    }

    private static String encoding(String source) {
        String encoding = DEFAULT_ENCODING;
        for (String line : source.split("\\n")) {
            if (!COMMENT_OR_EMPTY_LINE_PATTERN.matcher(line).find()) break;
            Matcher matcher = ENCODING_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            encoding = matcher.group(1);
            break;
        }
        return encoding.toUpperCase(Locale.ROOT);
    }
}

