/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Plugin;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.runner.EventBus;
import cucumber.runner.RunnerSupplier;
import cucumber.runner.SingletonRunnerSupplier;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.ExitStatus;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.FeatureSupplier;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import gherkin.events.PickleEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Runtime {
    private final ExitStatus exitStatus;
    private final RuntimeOptions runtimeOptions;
    private final RunnerSupplier runnerSupplier;
    private final Filters filters;
    private final EventBus bus;
    private final FeatureSupplier featureSupplier;
    private final Plugins plugins;
    private final ExecutorService executor;

    public Runtime(Plugins plugins, RuntimeOptions runtimeOptions, EventBus bus, Filters filters, RunnerSupplier runnerSupplier, FeatureSupplier featureSupplier, ExecutorService executor) {
        this.plugins = plugins;
        this.runtimeOptions = runtimeOptions;
        this.filters = filters;
        this.bus = bus;
        this.runnerSupplier = runnerSupplier;
        this.featureSupplier = featureSupplier;
        this.executor = executor;
        this.exitStatus = new ExitStatus(runtimeOptions);
        this.exitStatus.setEventPublisher(bus);
    }

    public void run() {
        List<CucumberFeature> features = this.featureSupplier.get();
        this.bus.send(new TestRunStarted(this.bus.getTime(), (long)this.bus.getTimeMillis()));
        for (CucumberFeature cucumberFeature : features) {
            cucumberFeature.sendTestSourceRead(this.bus);
        }
        StepDefinitionReporter stepDefinitionReporter = this.plugins.stepDefinitionReporter();
        this.runnerSupplier.get().reportStepDefinitions(stepDefinitionReporter);
        for (CucumberFeature feature : features) {
            for (final PickleEvent pickleEvent : feature.getPickles()) {
                if (!this.filters.matchesFilters(pickleEvent)) continue;
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Runtime.this.runnerSupplier.get().runPickle(pickleEvent);
                    }
                });
            }
        }
        this.executor.shutdown();
        try {
            while (!this.executor.awaitTermination(1L, TimeUnit.DAYS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            throw new CucumberException(interruptedException);
        }
        this.bus.send(new TestRunFinished(this.bus.getTime(), (long)this.bus.getTimeMillis()));
    }

    public byte exitStatus() {
        return this.exitStatus.exitStatus();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class SameThreadExecutorService
    extends AbstractExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }

    public static class Builder {
        private EventBus eventBus = new TimeServiceEventBus(TimeService.SYSTEM);
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private RuntimeOptions runtimeOptions = new RuntimeOptions("");
        private BackendSupplier backendSupplier;
        private ResourceLoader resourceLoader;
        private ClassFinder classFinder;
        private FeatureSupplier featureSupplier;
        private List<Plugin> additionalPlugins = Collections.emptyList();

        private Builder() {
        }

        public Builder withArg(String arg) {
            this.runtimeOptions = new RuntimeOptions(arg);
            return this;
        }

        public Builder withArgs(String ... args) {
            return this.withArgs(Arrays.asList(args));
        }

        public Builder withArgs(List<String> args) {
            this.runtimeOptions = new RuntimeOptions(args);
            return this;
        }

        public Builder withRuntimeOptions(RuntimeOptions runtimeOptions) {
            this.runtimeOptions = runtimeOptions;
            return this;
        }

        public Builder withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder withResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
            return this;
        }

        public Builder withClassFinder(ClassFinder classFinder) {
            this.classFinder = classFinder;
            return this;
        }

        public Builder withBackendSupplier(BackendSupplier backendSupplier) {
            this.backendSupplier = backendSupplier;
            return this;
        }

        public Builder withFeatureSupplier(FeatureSupplier featureSupplier) {
            this.featureSupplier = featureSupplier;
            return this;
        }

        public Builder withAdditionalPlugins(Plugin ... plugins) {
            this.additionalPlugins = Arrays.asList(plugins);
            return this;
        }

        public Builder withEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Runtime build() {
            ResourceLoader resourceLoader = this.resourceLoader != null ? this.resourceLoader : new MultiLoader(this.classLoader);
            ClassFinder classFinder = this.classFinder != null ? this.classFinder : new ResourceLoaderClassFinder(resourceLoader, this.classLoader);
            BackendSupplier backendSupplier = this.backendSupplier != null ? this.backendSupplier : new BackendModuleBackendSupplier(resourceLoader, classFinder, this.runtimeOptions);
            Plugins plugins = new Plugins(this.classLoader, new PluginFactory(), this.eventBus, this.runtimeOptions);
            for (Plugin plugin : this.additionalPlugins) {
                plugins.addPlugin(plugin);
            }
            RunnerSupplier runnerSupplier = this.runtimeOptions.isMultiThreaded() ? new ThreadLocalRunnerSupplier(this.runtimeOptions, this.eventBus, backendSupplier) : new SingletonRunnerSupplier(this.runtimeOptions, this.eventBus, backendSupplier);
            ExecutorService executor = this.runtimeOptions.isMultiThreaded() ? Executors.newFixedThreadPool(this.runtimeOptions.getThreads()) : new SameThreadExecutorService();
            FeatureLoader featureLoader = new FeatureLoader(resourceLoader);
            FeatureSupplier featureSupplier = this.featureSupplier != null ? this.featureSupplier : new FeaturePathFeatureSupplier(featureLoader, this.runtimeOptions);
            Filters filters = new Filters(this.runtimeOptions);
            return new Runtime(plugins, this.runtimeOptions, this.eventBus, filters, runnerSupplier, featureSupplier, executor);
        }
    }
}

