/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.android;

import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import dalvik.system.DexFile;
import io.cucumber.core.model.Classpath;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DexClassFinder
implements ClassFinder {
    private static final String MANIFEST_CLASS_NAME = "Manifest";
    private static final String RESOURCE_CLASS_NAME = "R";
    private static final String RESOURCE_INNER_CLASS_NAME_PREFIX = "R$";
    private static final String FILE_NAME_SEPARATOR = ".";
    private static final ClassLoader CLASS_LOADER = DexClassFinder.class.getClassLoader();
    private static final String DEFAULT_PACKAGE = "";
    private static final Pattern PATH_SEPARATOR_PATTERN = Pattern.compile("/", 16);
    private final DexFile dexFile;

    DexClassFinder(DexFile dexFile) {
        this.dexFile = dexFile;
    }

    public <T> Collection<Class<? extends T>> getDescendants(Class<T> parentType, URI packageName) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        String packageNameString = PATH_SEPARATOR_PATTERN.matcher(Classpath.resourceName((URI)packageName)).replaceAll(Matcher.quoteReplacement(FILE_NAME_SEPARATOR));
        Enumeration entries = this.dexFile.entries();
        while (entries.hasMoreElements()) {
            String className = (String)entries.nextElement();
            if (!this.isInPackage(className, packageNameString) || this.isGenerated(className)) continue;
            try {
                Class<T> clazz = this.loadClass(className);
                if (parentType.equals(clazz) || !parentType.isAssignableFrom(clazz)) continue;
                result.add(clazz.asSubclass(parentType));
            }
            catch (ClassNotFoundException e) {
                throw new CucumberException((Throwable)e);
            }
        }
        return result;
    }

    public <T> Class<? extends T> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className, false, CLASS_LOADER);
    }

    private boolean isInPackage(String className, String packageName) {
        int lastDotIndex = className.lastIndexOf(FILE_NAME_SEPARATOR);
        String classPackage = lastDotIndex == -1 ? DEFAULT_PACKAGE : className.substring(0, lastDotIndex);
        return classPackage.startsWith(packageName);
    }

    private boolean isGenerated(String className) {
        int lastDotIndex = className.lastIndexOf(FILE_NAME_SEPARATOR);
        String shortName = lastDotIndex == -1 ? className : className.substring(lastDotIndex + 1);
        return shortName.equals(MANIFEST_CLASS_NAME) || shortName.equals(RESOURCE_CLASS_NAME) || shortName.startsWith(RESOURCE_INNER_CLASS_NAME_PREFIX);
    }
}

