/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import io.cucumber.cienvironment.RemoveUserInfo;
import io.cucumber.cienvironment.VariableExpression;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class CiEnvironmentImpl
implements CiEnvironment {
    public String name;
    public String url;
    public String buildNumber;
    public Git git;

    CiEnvironmentImpl() {
    }

    CiEnvironmentImpl(String name, String url, String buildNumber, Git git) {
        this.name = Objects.requireNonNull(name);
        this.url = Objects.requireNonNull(url);
        this.buildNumber = buildNumber;
        this.git = git;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(this.buildNumber);
    }

    @Override
    public Optional<CiEnvironment.Git> getGit() {
        return Optional.ofNullable(this.git);
    }

    Optional<CiEnvironment> detect(Map<String, String> env) {
        String url = VariableExpression.evaluate(this.getUrl(), env);
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new CiEnvironmentImpl(this.name, url, VariableExpression.evaluate(this.getBuildNumber().orElse(null), env), this.detectGit(env)));
    }

    private Git detectGit(Map<String, String> env) {
        String revision = VariableExpression.evaluate(this.git.revision, env);
        if (revision == null) {
            return null;
        }
        String remote = VariableExpression.evaluate(this.git.remote, env);
        if (remote == null) {
            return null;
        }
        return new Git(RemoveUserInfo.fromUrl(remote), revision, VariableExpression.evaluate(this.git.branch, env), VariableExpression.evaluate(this.git.tag, env));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CiEnvironmentImpl that = (CiEnvironmentImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.git, that.git);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.buildNumber, this.git);
    }

    public String toString() {
        return "CiEnvironmentImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", buildNumber='" + this.buildNumber + '\'' + ", git=" + this.git + '}';
    }

    static final class Git
    implements CiEnvironment.Git {
        public String remote;
        public String revision;
        public String branch;
        public String tag;

        Git() {
        }

        Git(String remote, String revision, String branch, String tag) {
            this.remote = Objects.requireNonNull(remote);
            this.revision = Objects.requireNonNull(revision);
            this.branch = branch;
            this.tag = tag;
        }

        @Override
        public String getRemote() {
            return this.remote;
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        @Override
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Git git = (Git)o;
            return Objects.equals(this.remote, git.remote) && Objects.equals(this.revision, git.revision) && Objects.equals(this.branch, git.branch) && Objects.equals(this.tag, git.tag);
        }

        public int hashCode() {
            return Objects.hash(this.remote, this.revision, this.branch, this.tag);
        }

        public String toString() {
            return "Git{remote='" + this.remote + '\'' + ", revision='" + this.revision + '\'' + ", branch='" + this.branch + '\'' + ", tag='" + this.tag + '\'' + '}';
        }
    }
}

