/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import io.cucumber.cienvironment.DetectCiEnvironment;
import io.cucumber.cienvironment.VariableExpression;
import java.util.Map;
import java.util.Objects;

final class CiEnvironmentImpl
implements CiEnvironment {
    public String name;
    public String url;
    public String buildNumber;
    public Git git;

    CiEnvironmentImpl() {
    }

    CiEnvironmentImpl(String name, String url, String buildNumber, Git git) {
        this.name = name;
        this.url = url;
        this.buildNumber = buildNumber;
        this.git = git;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public CiEnvironment.Git getGit() {
        return this.git;
    }

    CiEnvironment detect(Map<String, String> env) {
        String url = VariableExpression.evaluate(this.getUrl(), env);
        if (url == null) {
            return null;
        }
        return new CiEnvironmentImpl(this.name, url, VariableExpression.evaluate(this.getBuildNumber(), env), new Git(DetectCiEnvironment.removeUserInfoFromUrl(VariableExpression.evaluate(this.git.remote, env)), VariableExpression.evaluate(this.git.revision, env), VariableExpression.evaluate(this.git.branch, env), VariableExpression.evaluate(this.git.tag, env)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CiEnvironmentImpl that = (CiEnvironmentImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.git, that.git);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.buildNumber, this.git);
    }

    public String toString() {
        return "CiEnvironmentImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", buildNumber='" + this.buildNumber + '\'' + ", git=" + this.git + '}';
    }

    static final class Git
    implements CiEnvironment.Git {
        public String remote;
        public String revision;
        public String branch;
        public String tag;

        Git() {
        }

        Git(String remote, String revision, String branch, String tag) {
            this.remote = remote;
            this.revision = revision;
            this.branch = branch;
            this.tag = tag;
        }

        @Override
        public String getRemote() {
            return this.remote;
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        @Override
        public String getBranch() {
            return this.branch;
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Git git = (Git)o;
            return Objects.equals(this.remote, git.remote) && Objects.equals(this.revision, git.revision) && Objects.equals(this.branch, git.branch) && Objects.equals(this.tag, git.tag);
        }

        public int hashCode() {
            return Objects.hash(this.remote, this.revision, this.branch, this.tag);
        }

        public String toString() {
            return "Git{remote='" + this.remote + '\'' + ", revision='" + this.revision + '\'' + ", branch='" + this.branch + '\'' + ", tag='" + this.tag + '\'' + '}';
        }
    }
}

