/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.services.dedupe.services;

import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.service.SimpleProcessingService;
import io.continual.util.time.Clock;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class DedupeService
extends SimpleProcessingService {
    private final HashMap<String, Entry> fLastSeenMs = new HashMap();
    private final LinkedList<Entry> fTimeOrder = new LinkedList();
    private final long fMaxAgeMs;
    private final long fMaxSize;
    private final ScheduledExecutorService fBackgroundProcessing;

    public DedupeService(ConfigLoadContext sc, JSONObject config) {
        this.fMaxAgeMs = config.optLong("maxAgeMs", Long.MAX_VALUE);
        this.fMaxSize = config.optLong("maxSize", Long.MAX_VALUE);
        this.fBackgroundProcessing = Executors.newScheduledThreadPool(1);
    }

    @Override
    protected void onStart() {
        this.fBackgroundProcessing.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DedupeService.this.cull();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    protected void onStopRequested() {
        this.fBackgroundProcessing.shutdown();
    }

    public synchronized boolean exists(String key) {
        this.cull();
        return this.fLastSeenMs.containsKey(key);
    }

    public synchronized void add(String key) {
        this.cull();
        Entry e = new Entry(key);
        this.fLastSeenMs.put(key, e);
        this.fTimeOrder.add(e);
    }

    public synchronized void remove(String key) {
        this.fLastSeenMs.remove(key);
        this.cull();
    }

    private synchronized void cull() {
        long oldestMs = Clock.now() - this.fMaxAgeMs;
        while (this.fTimeOrder.size() > 0 && (this.fTimeOrder.peek().fTimeMs < oldestMs || (long)this.fTimeOrder.size() > this.fMaxSize)) {
            Entry active;
            Entry e = this.fTimeOrder.remove(0);
            if (e != (active = this.fLastSeenMs.get(e.fKey))) continue;
            this.fLastSeenMs.remove(e.fKey);
        }
    }

    private static class Entry {
        public final String fKey;
        public final long fTimeMs;

        public Entry(String key) {
            this(key, Clock.now());
        }

        public Entry(String key, long timeMs) {
            this.fKey = key;
            this.fTimeMs = timeMs;
        }
    }
}

