/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.tools.jsonrpc;

import io.continual.shaded.com.rabbitmq.tools.jsonrpc.JsonRpcException;
import io.continual.shaded.com.rabbitmq.tools.jsonrpc.ServiceDescription;

public interface JsonRpcMapper {
    public JsonRpcRequest parse(String var1, ServiceDescription var2);

    public JsonRpcResponse parse(String var1, Class<?> var2);

    public String write(Object var1);

    public static class JsonRpcResponse {
        private final Object result;
        private final Object error;
        private final JsonRpcException exception;

        public JsonRpcResponse(Object result, Object error, JsonRpcException exception) {
            this.result = result;
            this.error = error;
            this.exception = exception;
        }

        public Object getError() {
            return this.error;
        }

        public Object getResult() {
            return this.result;
        }

        public JsonRpcException getException() {
            return this.exception;
        }
    }

    public static class JsonRpcRequest {
        private final Object id;
        private final String version;
        private final String method;
        private final Object[] parameters;

        public JsonRpcRequest(Object id, String version, String method, Object[] parameters) {
            this.id = id;
            this.version = version;
            this.method = method;
            this.parameters = parameters;
        }

        public Object getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String getMethod() {
            return this.method;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public boolean isSystem() {
            return this.method.startsWith("system.");
        }

        public boolean isSystemDescribe() {
            return "system.describe".equals(this.method);
        }
    }
}

