/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.tools;

import io.continual.iam.IamDb;
import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamGroupDoesNotExist;
import io.continual.iam.exceptions.IamGroupExists;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamIdentityExists;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.identity.Group;
import io.continual.iam.identity.Identity;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IamDbBackup<I extends Identity, G extends Group> {
    private final IamDb<I, G> fDb;
    private static final Logger log = LoggerFactory.getLogger(IamDbBackup.class);

    public IamDbBackup(IamDb<I, G> db) {
        this.fDb = db;
    }

    public void backupTo(OutputStream os) throws IamSvcException, IOException {
        JSONObject doc = new JSONObject();
        JSONObject users = new JSONObject();
        for (Map.Entry user : this.fDb.loadAllUsers().entrySet()) {
            Identity id = (Identity)user.getValue();
            JSONObject userRec = id instanceof CommonJsonIdentity ? ((CommonJsonIdentity)id).asJson() : new JSONObject();
            userRec.put("enabled", id.isEnabled()).put("groups", (Object)JsonVisitor.collectionToArray(id.getGroupIds())).put("data", (Object)JsonVisitor.mapOfStringsToObject(id.getAllUserData()));
            JSONObject apiKeys = new JSONObject();
            for (String apiKey : id.loadApiKeysForUser()) {
                ApiKey rec = this.fDb.loadApiKeyRecord(apiKey);
                apiKeys.put(apiKey, (Object)new JSONObject().put("secret", (Object)rec.getSecret()).put("createdAtMs", rec.getCreationTimestamp()));
            }
            userRec.put("apiKeys", (Object)apiKeys);
            users.put(user.getKey(), (Object)userRec);
        }
        doc.put("users", (Object)users);
        JSONObject groups = new JSONObject();
        for (String groupId : this.fDb.getAllGroups()) {
            Object group = this.fDb.loadGroup(groupId);
            JSONObject groupRec = new JSONObject().put("name", (Object)group.getName()).put("members", (Object)JsonVisitor.collectionToArray(group.getMembers())).put("data", (Object)JsonVisitor.mapOfStringsToObject(group.getAllUserData()));
            groups.put(groupId, (Object)groupRec);
        }
        doc.put("groups", (Object)groups);
        PrintWriter fw = new PrintWriter(os);
        Object object = null;
        try {
            fw.println(doc.toString(4));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fw != null) {
                if (object != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fw.close();
                }
            }
        }
    }

    public void restoreFrom(InputStream is) throws JSONException, FileNotFoundException, IOException, IamSvcException {
        JSONObject db = new JSONObject((JSONTokener)new CommentedJsonTokener(is));
        JsonVisitor.forEachElement((JSONObject)db.optJSONObject("groups"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, IamSvcException>(){

            public boolean visit(String groupId, JSONObject groupJson) throws JSONException, IamSvcException {
                Object group = IamDbBackup.this.fDb.loadGroup(groupId);
                if (group == null) {
                    try {
                        group = IamDbBackup.this.fDb.createGroup(groupId, groupJson.optString("name", groupId));
                    }
                    catch (IamGroupExists e) {
                        throw new IamSvcException("Conflict in DB response: group didn't exist, but IamGroupExists thrown");
                    }
                }
                final Object finalGroup = group;
                JsonVisitor.forEachElement((JSONObject)groupJson.optJSONObject("data"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<String, IamSvcException>(){

                    public boolean visit(String dataKey, String dataVal) throws IamSvcException {
                        finalGroup.putUserData(dataKey, dataVal);
                        return true;
                    }
                });
                return true;
            }
        });
        JsonVisitor.forEachElement((JSONObject)db.optJSONObject("users"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, IamSvcException>(){

            public boolean visit(final String userId, JSONObject user) throws JSONException, IamSvcException {
                if (!IamDbBackup.this.fDb.userExists(userId)) {
                    try {
                        IamDbBackup.this.fDb.createUser(userId);
                    }
                    catch (IamIdentityExists e) {
                        throw new IamSvcException("Conflict in DB response: user didn't exist, but IamIdentityExists thrown");
                    }
                }
                final Object userRec = IamDbBackup.this.fDb.loadUser(userId);
                userRec.enable(user.optBoolean("enabled", true));
                JSONObject pwdBlock = user.optJSONObject("password");
                if (pwdBlock != null && userRec instanceof CommonJsonIdentity) {
                    String salt = pwdBlock.getString("salt");
                    String hash = pwdBlock.getString("hash");
                    ((CommonJsonIdentity)userRec).setPasswordSaltAndHash(salt, hash);
                }
                JsonVisitor.forEachElement((JSONObject)user.optJSONObject("data"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<String, IamSvcException>(){

                    public boolean visit(String dataKey, String dataVal) throws IamSvcException {
                        userRec.putUserData(dataKey, dataVal);
                        return true;
                    }
                });
                JsonVisitor.forEachElement((JSONArray)user.optJSONArray("groups"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, IamSvcException>(){

                    public boolean visit(String groupId) throws IamSvcException {
                        try {
                            IamDbBackup.this.fDb.addUserToGroup(groupId, userId);
                        }
                        catch (IamGroupDoesNotExist | IamIdentityDoesNotExist e) {
                            throw new IamSvcException(e);
                        }
                        return true;
                    }
                });
                JsonVisitor.forEachElement((JSONObject)user.optJSONObject("apiKeys"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, IamSvcException>(){

                    public boolean visit(final String apiKey, final JSONObject apiKeyRecord) throws IamSvcException {
                        final String secret = apiKeyRecord.getString("secret");
                        ApiKey existingKey = IamDbBackup.this.fDb.loadApiKeyRecord(apiKey);
                        if (existingKey != null) {
                            if (!existingKey.getUserId().equals(userId)) {
                                log.warn("API key " + apiKey + " exists for user " + existingKey.getUserId() + " but is being restored for " + userId + ". Deleting the key entirely...");
                                IamDbBackup.this.fDb.loadUser(existingKey.getUserId()).deleteApiKey(existingKey);
                                return true;
                            }
                            if (!existingKey.getSecret().equals(secret)) {
                                userRec.deleteApiKey(existingKey);
                            } else {
                                return true;
                            }
                        }
                        try {
                            IamDbBackup.this.fDb.restoreApiKey(new ApiKey(){

                                @Override
                                public String getUserId() {
                                    return userId;
                                }

                                @Override
                                public String getKey() {
                                    return apiKey;
                                }

                                @Override
                                public String getSecret() {
                                    return secret;
                                }

                                @Override
                                public long getCreationTimestamp() {
                                    return apiKeyRecord.optLong("createdAtMs", Clock.now());
                                }
                            });
                        }
                        catch (IamBadRequestException e) {
                            throw new IamSvcException(e);
                        }
                        return true;
                    }
                });
                return true;
            }
        });
    }
}

