/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.jsondoc;

import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.impl.common.CommonJsonApiKey;
import io.continual.iam.impl.common.CommonJsonDb;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonDocDb
extends CommonJsonDb<CommonJsonIdentity, CommonJsonGroup> {
    private final JSONObject fTop;

    public JsonDocDb() {
        this(new JSONObject());
    }

    public JsonDocDb(JSONObject doc) {
        this.fTop = doc;
    }

    @Override
    public void close() {
    }

    public String serialize() {
        return this.fTop.toString();
    }

    @Override
    public List<String> findUsers(String startingWith) throws IamSvcException {
        LinkedList<String> result = new LinkedList<String>();
        for (String userId : this.getAllUsers()) {
            if (!userId.startsWith(startingWith)) continue;
            result.add(userId);
        }
        return result;
    }

    @Override
    public Collection<String> getAllUsers() throws IamSvcException {
        final TreeSet<String> result = new TreeSet<String>();
        JsonVisitor.forEachElement((JSONObject)this.fTop.optJSONObject("users"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, JSONException>(){

            public boolean visit(String userId, JSONObject user) throws JSONException {
                result.add(userId);
                return true;
            }
        });
        return result;
    }

    @Override
    public Collection<String> getAllGroups() throws IamSvcException {
        final TreeSet<String> result = new TreeSet<String>();
        JsonVisitor.forEachElement((JSONObject)this.fTop.optJSONObject("groups"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, JSONException>(){

            public boolean visit(String userId, JSONObject user) throws JSONException {
                result.add(userId);
                return true;
            }
        });
        return result;
    }

    @Override
    public Map<String, CommonJsonIdentity> loadAllUsers() throws IamSvcException {
        final HashMap<String, CommonJsonIdentity> result = new HashMap<String, CommonJsonIdentity>();
        JsonVisitor.forEachElement((JSONObject)this.fTop.optJSONObject("users"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, JSONException>(){

            public boolean visit(String userId, JSONObject user) throws JSONException {
                result.put(userId, JsonDocDb.this.instantiateIdentity(userId, user));
                return true;
            }
        });
        return result;
    }

    @Override
    public void sweepExpiredTags() throws IamSvcException {
        JSONObject tags = this.fTop.optJSONObject("tags");
        if (tags == null) {
            return;
        }
        JSONObject byTag = tags.optJSONObject("byTag");
        if (byTag == null) {
            return;
        }
        final LinkedList removals = new LinkedList();
        JsonVisitor.forEachElement((JSONObject)byTag, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, JSONException>(){

            public boolean visit(String key, JSONObject t) throws JSONException {
                if (JsonDocDb.isExpired(t)) {
                    removals.add(t);
                }
                return true;
            }
        });
        for (JSONObject tag : removals) {
            this.deleteTag(tag);
        }
    }

    @Override
    protected JSONObject createNewUser(String id) {
        return CommonJsonIdentity.initializeIdentity();
    }

    @Override
    protected JSONObject loadUserObject(String id) throws IamSvcException {
        JSONObject users = this.fTop.optJSONObject("users");
        if (users == null) {
            return null;
        }
        return users.optJSONObject(id);
    }

    @Override
    protected void storeUserObject(String id, JSONObject data) throws IamSvcException {
        JSONObject users = this.fTop.optJSONObject("users");
        if (users == null) {
            users = new JSONObject();
            this.fTop.put("users", (Object)users);
        }
        users.put(id, (Object)data);
    }

    @Override
    protected void deleteUserObject(String id) throws IamSvcException {
        JSONObject users = this.fTop.optJSONObject("users");
        if (null != users) {
            users.remove(id);
        }
    }

    @Override
    protected CommonJsonIdentity instantiateIdentity(String id, JSONObject data) {
        return new CommonJsonIdentity(id, data, this);
    }

    @Override
    protected JSONObject createNewGroup(String id, String groupDesc) {
        return CommonJsonGroup.initializeGroup(groupDesc);
    }

    @Override
    protected JSONObject loadGroupObject(String id) throws IamSvcException {
        JSONObject groups = this.fTop.optJSONObject("groups");
        if (groups == null) {
            return null;
        }
        return groups.optJSONObject(id);
    }

    @Override
    protected void storeGroupObject(String id, JSONObject data) throws IamSvcException {
        JSONObject groups = this.fTop.optJSONObject("groups");
        if (groups == null) {
            groups = new JSONObject();
            this.fTop.put("groups", (Object)groups);
        }
        groups.put(id, (Object)data);
    }

    @Override
    protected void deleteGroupObject(String id) throws IamSvcException {
        JSONObject groups = this.fTop.optJSONObject("groups");
        if (groups != null) {
            groups.remove(id);
        }
    }

    @Override
    protected CommonJsonGroup instantiateGroup(String id, JSONObject data) {
        return new CommonJsonGroup(id, data, this);
    }

    @Override
    protected JSONObject createApiKeyObject(String userId, String apiKey, String apiSecret) {
        return CommonJsonApiKey.initialize(apiSecret, userId);
    }

    @Override
    protected JSONObject loadApiKeyObject(String id) throws IamSvcException {
        JSONObject apiKeys = this.fTop.optJSONObject("apikeys");
        if (apiKeys == null) {
            return null;
        }
        return apiKeys.optJSONObject(id);
    }

    @Override
    protected void storeApiKeyObject(String apiKeyId, JSONObject data) throws IamSvcException, IamBadRequestException {
        TreeSet existing;
        String userId = data.optString("userId", null);
        if (userId == null) {
            throw new IamBadRequestException("no user specified for api key");
        }
        JSONObject user = this.loadUserObject(data.getString("userId"));
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONObject apiKeys = this.fTop.optJSONObject("apikeys");
        if (apiKeys == null) {
            apiKeys = new JSONObject();
            this.fTop.put("apikeys", (Object)apiKeys);
        }
        apiKeys.put(apiKeyId, (Object)data);
        JSONArray userApiKeys = user.optJSONArray("apiKeys");
        if (userApiKeys == null) {
            userApiKeys = new JSONArray();
            user.put("apiKeys", (Object)apiKeys);
        }
        if (!(existing = new TreeSet(JsonVisitor.arrayToList((JSONArray)userApiKeys))).contains(apiKeyId)) {
            userApiKeys.put((Object)apiKeyId);
        }
    }

    @Override
    protected void deleteApiKeyObject(String id) throws IamSvcException {
        String userId;
        JSONObject user;
        JSONArray userApiKeys;
        JSONObject apiKeys = this.fTop.optJSONObject("apikeys");
        if (apiKeys == null) {
            return;
        }
        JSONObject apiKey = apiKeys.getJSONObject(id);
        if (apiKey != null && (userApiKeys = (user = this.loadUserObject(userId = apiKey.getString("userId"))).optJSONArray("apiKeys")) != null) {
            JsonUtil.removeStringFromArray((JSONArray)userApiKeys, (String)id);
        }
    }

    @Override
    protected ApiKey instantiateApiKey(String id, JSONObject data) {
        return new CommonJsonApiKey(id, data);
    }

    @Override
    protected Collection<String> loadApiKeysForUser(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONArray userApiKeys = user.optJSONArray("apiKeys");
        if (userApiKeys != null) {
            return JsonVisitor.arrayToList((JSONArray)userApiKeys);
        }
        return new LinkedList<String>();
    }

    @Override
    protected JSONObject loadAclObject(String id) throws IamSvcException {
        JSONObject acls = this.fTop.optJSONObject("acls");
        if (acls == null) {
            return null;
        }
        return acls.optJSONObject(id);
    }

    @Override
    protected void storeAclObject(String id, JSONObject data) throws IamSvcException {
        JSONObject acls = this.fTop.optJSONObject("acls");
        if (acls == null) {
            acls = new JSONObject();
            this.fTop.put("acls", (Object)acls);
        }
        acls.put(id, (Object)data);
    }

    @Override
    protected void deleteAclObject(String id) throws IamSvcException {
        JSONObject acls = this.fTop.optJSONObject("acls");
        if (acls != null) {
            acls.remove(id);
        }
    }

    private static boolean isExpired(JSONObject entry) {
        long expireEpoch = entry.getLong("expireEpoch");
        return expireEpoch < Clock.now() / 1000L;
    }

    @Override
    protected JSONObject loadTagObject(String id, boolean expiredOk) throws IamSvcException {
        JSONObject tags = this.fTop.optJSONObject("tags");
        if (tags == null) {
            return null;
        }
        JSONObject byTag = tags.optJSONObject("byTag");
        if (byTag == null) {
            return null;
        }
        JSONObject entry = byTag.optJSONObject(id);
        if (entry == null) {
            return null;
        }
        if (JsonDocDb.isExpired(entry) && !expiredOk) {
            this.removeMatchingTag(entry.getString("userId"), entry.getString("tagType"));
            return null;
        }
        return entry;
    }

    @Override
    protected JSONObject loadTagObject(String userId, String appTagType, boolean expiredOk) throws IamSvcException {
        JSONObject tags = this.fTop.optJSONObject("tags");
        if (tags == null) {
            return null;
        }
        JSONObject byUser = tags.optJSONObject("byUser");
        if (byUser == null) {
            return null;
        }
        JSONObject thisUser = byUser.optJSONObject(userId);
        if (thisUser == null) {
            return null;
        }
        JSONObject entry = thisUser.optJSONObject(appTagType);
        if (entry == null) {
            return null;
        }
        if (JsonDocDb.isExpired(entry) && !expiredOk) {
            this.removeMatchingTag(userId, appTagType);
            return null;
        }
        return entry;
    }

    @Override
    protected void storeTagObject(String id, String userId, String appTagType, JSONObject data) throws IamSvcException {
        JSONObject thisUser;
        JSONObject byUser;
        JSONObject byTag;
        JSONObject tags = this.fTop.optJSONObject("tags");
        if (tags == null) {
            tags = new JSONObject();
            this.fTop.put("tags", (Object)tags);
        }
        if ((byTag = tags.optJSONObject("byTag")) == null) {
            byTag = new JSONObject();
            tags.put("byTag", (Object)byTag);
        }
        if ((byUser = tags.optJSONObject("byUser")) == null) {
            byUser = new JSONObject();
            tags.put("byUser", (Object)byUser);
        }
        if ((thisUser = byUser.optJSONObject(userId)) == null) {
            thisUser = new JSONObject();
            byUser.put(userId, (Object)thisUser);
        }
        byTag.put(id, (Object)data);
        thisUser.put(appTagType, (Object)data);
    }

    private void deleteTag(JSONObject entry) throws JSONException, IamSvcException {
        this.deleteTagObject(entry.getString("tagId"), entry.getString("userId"), entry.getString("tagType"));
    }

    @Override
    protected void deleteTagObject(String id, String userId, String appTagType) throws IamSvcException {
        JSONObject thisUser;
        JSONObject byUser;
        JSONObject tags = this.fTop.optJSONObject("tags");
        if (tags == null) {
            return;
        }
        JSONObject byTag = tags.optJSONObject("byTag");
        if (byTag != null) {
            byTag.remove(id);
        }
        if ((byUser = tags.optJSONObject("byUser")) != null && (thisUser = byUser.optJSONObject(userId)) != null) {
            thisUser.remove(appTagType);
        }
    }

    @Override
    protected JSONObject loadAliasObject(String id) throws IamSvcException {
        JSONObject aliases = this.fTop.optJSONObject("aliases");
        if (aliases == null) {
            return null;
        }
        return aliases.optJSONObject(id);
    }

    @Override
    protected void storeAliasObject(String apiKeyId, JSONObject data) throws IamBadRequestException, IamSvcException {
        TreeSet existing;
        String userId = data.optString("userId", null);
        if (userId == null) {
            throw new IamBadRequestException("no user specified on alias record");
        }
        JSONObject user = this.loadUserObject(data.getString("userId"));
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONObject aliasKeys = this.fTop.optJSONObject("aliases");
        if (aliasKeys == null) {
            aliasKeys = new JSONObject();
            this.fTop.put("aliases", (Object)aliasKeys);
        }
        aliasKeys.put(apiKeyId, (Object)data);
        JSONArray userAliases = user.optJSONArray("aliases");
        if (userAliases == null) {
            userAliases = new JSONArray();
            user.put("aliases", (Object)aliasKeys);
        }
        if (!(existing = new TreeSet(JsonVisitor.arrayToList((JSONArray)userAliases))).contains(apiKeyId)) {
            userAliases.put((Object)apiKeyId);
        }
    }

    @Override
    protected void deleteAliasObject(String id) throws IamSvcException {
        String userId;
        JSONObject user;
        JSONArray userAliases;
        JSONObject aliases = this.fTop.optJSONObject("aliases");
        if (aliases == null) {
            return;
        }
        JSONObject alias = aliases.getJSONObject(id);
        if (alias != null && (userAliases = (user = this.loadUserObject(userId = alias.getString("userId"))).optJSONArray("aliases")) != null) {
            JsonUtil.removeStringFromArray((JSONArray)userAliases, (String)id);
        }
    }

    @Override
    protected Collection<String> loadAliasesForUser(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONArray userAliases = user.optJSONArray("aliases");
        if (userAliases != null) {
            return JsonVisitor.arrayToList((JSONArray)userAliases);
        }
        return new LinkedList<String>();
    }

    @Override
    protected void storeInvalidJwtToken(String token) throws IamSvcException {
        JSONObject tokens = this.fTop.optJSONObject("tokens");
        if (tokens == null) {
            tokens = new JSONObject();
            this.fTop.put("tokens", (Object)tokens);
        }
        tokens.put(token, Clock.now());
    }

    @Override
    protected boolean isInvalidJwtToken(String token) throws IamSvcException {
        JSONObject tokens = this.fTop.optJSONObject("tokens");
        return tokens != null && tokens.has(token);
    }
}

