/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.json.JsonVisitor;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class SplitValue
implements Processor {
    private final String fPatternText;
    private final Pattern fPattern;
    private final String fValueExpr;
    private final Map<String, String> fTargetFields;

    public SplitValue(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this.fPatternText = config.getString("pattern");
        this.fPattern = Pattern.compile(this.fPatternText);
        this.fValueExpr = config.getString("value");
        this.fTargetFields = JsonVisitor.objectToMap((JSONObject)config.getJSONObject("assignments"));
    }

    @Override
    public void process(MessageProcessingContext ctx) {
        String value = ctx.evalExpression(this.fValueExpr);
        final Matcher m = this.fPattern.matcher(value);
        if (m.matches()) {
            ExprDataSource matcherSrc = new ExprDataSource(){

                public Object eval(String label) {
                    try {
                        int arg = Integer.parseInt(label);
                        if (arg >= 0 && arg < m.groupCount() + 1) {
                            return m.group(arg);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            for (Map.Entry<String, String> e : this.fTargetFields.entrySet()) {
                String val = ctx.evalExpression(e.getValue(), String.class, matcherSrc);
                ctx.getMessage().putValue(e.getKey(), val);
            }
        }
    }
}

