/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common;

import io.continual.iam.IamAuthLog;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.impl.common.HeaderReader;
import io.continual.util.data.TypeConvertor;
import io.continual.util.nv.NvReadable;

public class BasicAuthHelper {
    public static final String kSetting_AuthHeader = "Authorization";

    public static UsernamePasswordCredential readUsernamePasswordCredential(NvReadable settings, HeaderReader hr) {
        String authLine = hr.getFirstHeader(kSetting_AuthHeader);
        if (authLine == null) {
            IamAuthLog.debug("No Authorization header");
            return null;
        }
        String[] parts = authLine.split(" ");
        if (parts.length != 2 || !parts[0].equals("Basic")) {
            IamAuthLog.info("Authorization value is illegal");
            return null;
        }
        byte[] decoded = TypeConvertor.base64Decode((String)parts[1]);
        String creds = new String(decoded);
        int colon = creds.indexOf(58);
        if (colon == -1) {
            IamAuthLog.info("Authorization was provided but is malformed");
            return null;
        }
        String username = creds.substring(0, colon);
        if (username.isEmpty()) {
            IamAuthLog.info("username is empty");
            return null;
        }
        String password = creds.substring(colon + 1);
        return new UsernamePasswordCredential(username, password);
    }
}

