/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.builder.Builder;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.metricTypes.Timer;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.sources.BasicSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.data.json.CommentedJsonTokener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectFileSource
extends BasicSource {
    private final String fFilename;
    private BufferedReader fSrc;
    private boolean fEof;
    private static final Logger log = LoggerFactory.getLogger(JsonObjectFileSource.class);

    public JsonObjectFileSource(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        super(config);
        this.fFilename = config.getString("file");
        this.fEof = false;
        this.fSrc = null;
    }

    public JsonObjectFileSource(String filename) throws Builder.BuildFailure {
        this.fFilename = filename;
        this.fEof = false;
        this.fSrc = null;
    }

    @Override
    public synchronized boolean isEof() {
        return this.fEof;
    }

    @Override
    protected synchronized MessageAndRouting internalGetNextMessage(StreamProcessingContext spc) throws IOException, InterruptedException {
        String line;
        if (this.fEof) {
            return null;
        }
        if (this.fSrc == null) {
            String filename = spc.evalExpression(this.fFilename);
            log.info("loading {}", (Object)filename);
            this.fSrc = new BufferedReader(new FileReader(filename));
        }
        MetricsCatalog metrics = spc.getMetrics().getSubCatalog("JsonObjectFileSource");
        try (Timer.Context rltc = metrics.timer("readLine").time();){
            line = this.fSrc.readLine();
        }
        if (line != null) {
            JSONObject data;
            try (Timer.Context ptc = metrics.timer("jsonParse").time();){
                data = new JSONObject((JSONTokener)new CommentedJsonTokener(line));
            }
            Message msg = Message.adoptJsonAsMessage(data);
            return this.makeDefRoutingMessage(msg);
        }
        this.fEof = true;
        this.fSrc.close();
        return null;
    }
}

