/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.access;

import io.continual.util.data.json.JsonVisitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class AccessControlEntry {
    public static final String kAnyUser = "*";
    public static final String kAnyOperation = "*";
    public static final String kOwner = "~owner~";
    private final String fWho;
    private final TreeSet<String> fOperations;
    private final Access fPermission;

    public static Builder builder() {
        return new Builder();
    }

    public AccessControlEntry(String userOrGroupId, Access p, String operation) {
        this(userOrGroupId, p, new String[]{operation});
    }

    public AccessControlEntry(String userOrGroupId, Access p, String[] operations) {
        this.fWho = userOrGroupId;
        this.fOperations = new TreeSet();
        this.fPermission = p;
        for (String op : operations) {
            this.fOperations.add(op);
        }
    }

    public AccessControlEntry(String userOrGroupId, Access p, Collection<String> a) {
        this.fWho = userOrGroupId;
        this.fPermission = p;
        this.fOperations = new TreeSet<String>(a);
    }

    public AccessControlEntry clone() {
        return new AccessControlEntry(this.fWho, this.fPermission, this.fOperations);
    }

    public Access check(String userId, Set<String> groups, boolean isOwner, String op) {
        if (this.fWho.equals("*") || this.fWho.equals(userId) || groups != null && groups.contains(this.fWho) || isOwner && this.fWho.equals(kOwner)) {
            for (String listedOp : this.fOperations) {
                if (!listedOp.equalsIgnoreCase(op) && !listedOp.equals("*")) continue;
                return this.fPermission;
            }
        }
        return null;
    }

    public String getSubject() {
        return this.fWho;
    }

    public Access getPermission() {
        return this.fPermission;
    }

    public Set<String> getOperationSet() {
        return new TreeSet<String>((SortedSet<String>)this.fOperations);
    }

    public String[] getOperations() {
        return this.fOperations.toArray(new String[this.fOperations.size()]);
    }

    public int getOperationCount() {
        return this.fOperations.size();
    }

    public boolean removeOperation(String op) {
        return this.fOperations.remove(op);
    }

    public String toString() {
        return this.serialize().toString();
    }

    public JSONObject serialize() {
        JSONArray ops = new JSONArray();
        for (String op : this.fOperations) {
            ops.put((Object)op);
        }
        return new JSONObject().put("who", (Object)this.fWho).put("access", (Object)this.fPermission.toString()).put("operations", (Object)ops);
    }

    public static AccessControlEntry deserialize(JSONObject o) {
        return AccessControlEntry.builder().forSubject(o.getString("who")).withAccess(Access.valueOf(o.getString("access"))).operations(JsonVisitor.arrayToList((JSONArray)o.getJSONArray("operations"))).build();
    }

    private AccessControlEntry(Builder b) {
        this(b.fUserOrGroupId, b.fAccess, b.fOps);
    }

    public static class Builder {
        private String fUserOrGroupId;
        private Access fAccess = Access.PERMIT;
        private LinkedList<String> fOps = new LinkedList();

        public Builder forSubject(String userOrGroupId) {
            this.fUserOrGroupId = userOrGroupId;
            return this;
        }

        public Builder forAllUsers() {
            return this.forSubject("*");
        }

        public Builder forOwner() {
            return this.forSubject(AccessControlEntry.kOwner);
        }

        public Builder permit() {
            return this.withAccess(Access.PERMIT);
        }

        public Builder deny() {
            return this.withAccess(Access.DENY);
        }

        public Builder withAccess(Access a) {
            this.fAccess = a;
            return this;
        }

        public Builder operation(String op) {
            this.fOps.add(op);
            return this;
        }

        public Builder operations(String ... ops) {
            for (String op : ops) {
                this.fOps.add(op);
            }
            return this;
        }

        public Builder operations(Collection<String> ops) {
            this.fOps.addAll(ops);
            return this;
        }

        public Builder forAnyOperation() {
            return this.operation("*");
        }

        public AccessControlEntry build() {
            return new AccessControlEntry(this);
        }
    }

    public static enum Access {
        PERMIT,
        DENY;

    }
}

