/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.nv.impl;

import io.continual.util.data.StringUtils;
import io.continual.util.data.TypeConvertor;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.NvWriteable;
import java.util.Map;

public abstract class nvBaseReadable
implements NvReadable {
    @Override
    public abstract boolean hasValueFor(String var1);

    @Override
    public abstract String getString(String var1) throws NvReadable.MissingReqdSettingException;

    protected nvBaseReadable() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.getAllKeys()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String val = this.getString(key, "??");
            sb.append(key).append(":").append(val);
        }
        return sb.toString();
    }

    @Override
    public String get(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defValue) {
        try {
            return this.getString(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public boolean getBoolean(String key) throws NvReadable.MissingReqdSettingException {
        return TypeConvertor.convertToBoolean(this.getString(key));
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        try {
            return this.getBoolean(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public int getInt(String key) throws NvReadable.MissingReqdSettingException {
        try {
            return TypeConvertor.convertToInt(this.getString(key));
        }
        catch (TypeConvertor.conversionError e) {
            throw new NvReadable.MissingReqdSettingException(key, e);
        }
    }

    @Override
    public int getInt(String key, int defValue) {
        try {
            return this.getInt(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public double getDouble(String key) throws NvReadable.MissingReqdSettingException {
        try {
            return TypeConvertor.convertToDouble(this.getString(key));
        }
        catch (TypeConvertor.conversionError e) {
            throw new NvReadable.MissingReqdSettingException(key, e);
        }
    }

    @Override
    public double getDouble(String key, double defValue) {
        try {
            return this.getDouble(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public abstract String[] getStrings(String var1) throws NvReadable.MissingReqdSettingException;

    @Override
    public String[] getStrings(String key, String[] defValue) {
        try {
            return this.getStrings(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public char getCharacter(String key) throws NvReadable.MissingReqdSettingException {
        try {
            return TypeConvertor.convertToCharacter(this.getString(key));
        }
        catch (TypeConvertor.conversionError e) {
            throw new NvReadable.MissingReqdSettingException(key, e);
        }
    }

    @Override
    public char getCharacter(String key, char defValue) {
        try {
            return this.getCharacter(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public long getLong(String key) throws NvReadable.MissingReqdSettingException {
        try {
            return TypeConvertor.convertToLong(this.getString(key));
        }
        catch (TypeConvertor.conversionError e) {
            throw new NvReadable.MissingReqdSettingException(key, e);
        }
    }

    @Override
    public long getLong(String key, long defValue) {
        try {
            return this.getLong(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public byte[] getBytes(String key) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException {
        try {
            return TypeConvertor.hexToBytes(this.getString(key));
        }
        catch (TypeConvertor.conversionError e) {
            throw new NvReadable.InvalidSettingValueException(key, e);
        }
    }

    @Override
    public byte[] getBytes(String key, byte[] defValue) {
        try {
            return this.getBytes(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
        catch (NvReadable.InvalidSettingValueException e) {
            return defValue;
        }
    }

    @Override
    public void copyInto(NvWriteable writeable) {
        for (Map.Entry<String, String> e : this.getCopyAsMap().entrySet()) {
            writeable.set(e.getKey(), e.getValue());
        }
    }

    @Override
    public void copyInto(Map<String, String> writeable) {
        for (Map.Entry<String, String> e : this.getCopyAsMap().entrySet()) {
            writeable.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void rescan() throws NvReadable.LoadException {
    }

    protected String eval(String val) {
        return StringUtils.evaluate(this, val);
    }
}

