/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.csv;

import io.continual.util.data.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CsvStream {
    public static final String kLineField = "line";
    public static final String kLineField_Default = "line";
    public static final String kHasHeaderRow = "header";
    public static final String kDelimiter = "delimiter";
    public static final String kQuote = "quote";
    public static final String kPassThru = "passthru";
    private int fLineCount;
    private final char fDelimiter;
    private final char fQuote;
    private String[] fColumns;
    private boolean fHasHeaderRow;
    private final ArrayList<HashMap<String, String>> fRecords;

    public CsvStream(boolean header) {
        this('\"', ',', header);
    }

    public CsvStream(char quoteChar, char fieldSepChar, boolean header) {
        this.fDelimiter = fieldSepChar;
        this.fQuote = quoteChar;
        this.fColumns = null;
        this.fHasHeaderRow = header;
        this.fLineCount = 0;
        this.fRecords = new ArrayList();
    }

    public void reset() {
        this.fLineCount = 0;
        this.fRecords.clear();
    }

    public void read(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.read(br);
    }

    public void read(BufferedReader br) throws IOException {
        String s;
        while ((s = br.readLine()) != null) {
            s = s.trim();
            if (this.fLineCount == 0 && this.fHasHeaderRow) {
                this.parseHeader(s);
            } else {
                HashMap<String, String> rec = this.parseLine(s);
                this.fRecords.add(rec);
            }
            ++this.fLineCount;
        }
    }

    public Vector<String> getColumnNames() {
        Vector<String> result = new Vector<String>();
        for (String c : this.fColumns) {
            result.add(c);
        }
        return result;
    }

    public int getLinesParsed() {
        return this.fLineCount;
    }

    public int getRecordCount() {
        return this.fRecords.size();
    }

    public Map<String, String> getRecord(int row) {
        return this.fRecords.get(row);
    }

    public String getField(int row, int field) {
        String name = this.fColumns != null && field < this.fColumns.length ? this.fColumns[field] : "" + field;
        return this.getRecord(row).get(name);
    }

    public static List<String> parseHeaderLine(String line, char quote, char delim) {
        LinkedList<String> headers = new LinkedList<String>();
        String remains = line;
        while (remains.length() > 0) {
            StringUtils.valueInfo result = StringUtils.getLeadingValue(remains, quote, delim);
            if (result == null) continue;
            if (result.fValue == null) {
                result = new StringUtils.valueInfo("unnamed-" + (headers.size() + 1), result.fNextFieldAt);
            }
            headers.add(result.fValue);
            if (result.fNextFieldAt > -1) {
                remains = remains.substring(result.fNextFieldAt);
                continue;
            }
            remains = "";
        }
        return headers;
    }

    private void parseHeader(String line) {
        LinkedList<String> headers = new LinkedList<String>();
        String remains = line;
        while (remains.length() > 0) {
            StringUtils.valueInfo result = StringUtils.getLeadingValue(remains, this.fQuote, this.fDelimiter);
            if (result == null) continue;
            if (result.fValue == null) {
                result = new StringUtils.valueInfo("unnamed-" + (headers.size() + 1), result.fNextFieldAt);
            }
            headers.add(result.fValue);
            if (result.fNextFieldAt > -1) {
                remains = remains.substring(result.fNextFieldAt);
                continue;
            }
            remains = "";
        }
        this.fColumns = headers.toArray(new String[headers.size()]);
    }

    protected HashMap<String, String> parseLine(String line) {
        HashMap<String, String> result = new HashMap<String, String>();
        int colNum = 0;
        String remains = new String(line);
        while (remains != null) {
            StringUtils.valueInfo vi = StringUtils.getLeadingValue(remains, this.fQuote, this.fDelimiter);
            String name = this.fColumns != null && colNum < this.fColumns.length ? this.fColumns[colNum] : "" + colNum;
            ++colNum;
            result.put(name, vi.fValue);
            if (vi.fNextFieldAt > -1) {
                remains = remains.substring(vi.fNextFieldAt);
                continue;
            }
            remains = null;
        }
        return result;
    }
}

