/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console.shell;

import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleLineReader;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.console.shell.Command;
import io.continual.util.console.shell.CommandList;
import io.continual.util.console.shell.StdCommandList;
import io.continual.util.nv.NvReadable;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class ConsoleLooper
implements ConsoleProgram.Looper {
    public static final String kSetting_Quiet = "quiet";
    private String[] fHeaderLines;
    private final LinkedList<String> fInputQueue;
    private final String fPrompt;
    private final String fSecondaryPrompt;
    private boolean fEnableHelp;
    private InputResult fState;
    private final CommandList fCommands;
    private final HashMap<String, Object> fWorkspace;
    public static final String kCmdPrefix = "__";
    public static final int kCmdPrefixLength = "__".length();

    public ConsoleLooper(String[] headerLines, String prompt, String secondaryPrompt, CommandList cl) {
        this.fHeaderLines = headerLines;
        this.fInputQueue = new LinkedList();
        this.fPrompt = prompt;
        this.fSecondaryPrompt = secondaryPrompt;
        this.fEnableHelp = true;
        this.fWorkspace = new HashMap();
        this.fState = InputResult.kReady;
        this.fCommands = cl;
    }

    @Override
    public boolean setup(NvReadable p, CmdLinePrefs clp) {
        String args;
        boolean quiet = p.getBoolean(kSetting_Quiet, false);
        if (clp != null && (args = clp.getFileArgumentsAsString()) != null && args.length() > 0) {
            this.queue(args);
            this.queue("quit");
            quiet = true;
        }
        if (!quiet) {
            this.writeHeader();
        }
        return true;
    }

    @Override
    public void teardown(NvReadable p) {
    }

    @Override
    public boolean loop(NvReadable p) {
        boolean result = true;
        try {
            String line = this.getInput();
            if (line != null) {
                this.fState = this.handleInput(p, line, System.out);
                if (this.fState == null) {
                    this.fState = InputResult.kReady;
                }
            } else {
                result = false;
            }
        }
        catch (IOException x) {
            System.err.println(x.getMessage());
            result = false;
        }
        return result && !this.fState.equals((Object)InputResult.kQuit);
    }

    public synchronized void queue(String input) {
        this.fInputQueue.add(input);
    }

    public synchronized void queueFromCmdLine(CmdLinePrefs clp, boolean withQuit) {
        Vector<String> args = clp.getFileArguments();
        if (args.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (String s : args) {
                sb.append(s);
                sb.append(' ');
            }
            this.queue(sb.toString());
            if (withQuit) {
                this.queue("quit");
            }
        }
    }

    protected void writeHeader() {
        if (this.fHeaderLines != null) {
            for (String header : this.fHeaderLines) {
                System.out.println(header);
            }
        }
    }

    protected InputResult handleInput(NvReadable p, String input, PrintStream outputTo) {
        InputResult result = InputResult.kReady;
        String[] commandLine = ConsoleLooper.splitLine(input);
        result = commandLine.length == 0 ? this.handleEmptyLine(p, outputTo) : this.handleCommand(p, commandLine, outputTo);
        return result;
    }

    protected InputResult handleEmptyLine(NvReadable p, PrintStream outputTo) {
        return InputResult.kReady;
    }

    protected InputResult handleCommand(NvReadable p, String[] commandLine, PrintStream outputTo) {
        InputResult result = InputResult.kReady;
        Command m = this.getHandler(commandLine);
        if (m != null) {
            int argsLen = commandLine.length - 1;
            String[] args = new String[argsLen];
            System.arraycopy(commandLine, 1, args, 0, argsLen);
            try {
                result = this.invoke(m, p, args, outputTo);
            }
            catch (Exception x) {
                result = this.handleInvocationException(commandLine, x, outputTo);
            }
        } else {
            result = this.handleUnrecognizedCommand(commandLine, outputTo);
        }
        return result;
    }

    protected InputResult invoke(Command m, NvReadable p, String[] args, PrintStream outputTo) {
        try {
            m.checkArgs(p, args);
            return m.execute(this.fWorkspace, outputTo);
        }
        catch (ConsoleProgram.UsageException x) {
            outputTo.println(m.getUsage());
            outputTo.println(x.getMessage());
            return InputResult.kReady;
        }
    }

    protected InputResult handleUnrecognizedCommand(String[] commandLine, PrintStream outputTo) {
        outputTo.println("Unrecognized command '" + commandLine[0] + "'.");
        return InputResult.kReady;
    }

    protected InputResult handleInvocationException(String[] commandLine, Exception x, PrintStream outputTo) {
        if (x instanceof InvocationTargetException) {
            InvocationTargetException itc = (InvocationTargetException)x;
            Throwable target = itc.getTargetException();
            outputTo.println("ERROR: " + target.getClass().getName() + ": " + target.getMessage());
        } else {
            outputTo.println("Error running command '" + commandLine[0] + "'. " + x.getMessage());
        }
        return InputResult.kReady;
    }

    protected HashMap<String, Object> getWorkspace() {
        return this.fWorkspace;
    }

    private synchronized String getInput() throws IOException {
        String input = null;
        if (this.fInputQueue.size() > 0) {
            input = this.fInputQueue.remove();
        } else {
            String prompt = this.fPrompt;
            if (this.fState == InputResult.kReady) {
                System.out.println();
            } else {
                prompt = this.fSecondaryPrompt;
            }
            input = ConsoleLineReader.getLine(prompt);
        }
        return input;
    }

    static String[] splitLine(String line) {
        LinkedList<String> tokens = new LinkedList<String>();
        StringBuffer current = new StringBuffer();
        boolean quoting = false;
        boolean lastWasWs = true;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) && !quoting) {
                if (current.length() > 0) {
                    tokens.add(current.toString());
                }
                current = new StringBuffer();
                lastWasWs = true;
                continue;
            }
            if (c == '\"') {
                if (lastWasWs) {
                    quoting = true;
                } else if (!quoting) {
                    current.append(c);
                } else {
                    tokens.add(current.toString());
                    current = new StringBuffer();
                    quoting = false;
                }
                lastWasWs = false;
                continue;
            }
            current.append(c);
            lastWasWs = false;
        }
        if (current.length() > 0) {
            tokens.add(current.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private Command getHandler(String[] cmdLine) {
        if (cmdLine.length > 0) {
            return this.fCommands.getCommandFor(cmdLine[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __script(String[] args, PrintStream outTo) throws ConsoleProgram.UsageException, IOException {
        String input;
        if (args.length != 2) {
            throw new ConsoleProgram.UsageException("script <file>");
        }
        LinkedList<String> lines = new LinkedList<String>();
        String filename = args[1];
        BufferedReader bis = new BufferedReader(new FileReader(filename));
        while ((input = bis.readLine()) != null) {
            lines.add(input);
        }
        bis.close();
        ConsoleLooper consoleLooper = this;
        synchronized (consoleLooper) {
            this.fInputQueue.addAll(0, lines);
        }
    }

    public void __help(String[] args, PrintStream outTo) throws ConsoleProgram.UsageException, IOException {
        if (this.fEnableHelp) {
            TreeSet<String> allMethods = new TreeSet<String>();
            Class<?> clazz = this.getClass();
            while (!clazz.equals(Object.class)) {
                Method[] methods;
                for (Method m : methods = clazz.getDeclaredMethods()) {
                    Class<?>[] params;
                    String methodName = m.getName();
                    if (!methodName.startsWith(kCmdPrefix) || methodName.length() <= kCmdPrefixLength || (params = m.getParameterTypes()).length != 2 || !params[0].equals(String[].class) || !params[1].equals(PrintStream.class)) continue;
                    allMethods.add(methodName.substring(kCmdPrefixLength));
                }
                clazz = clazz.getSuperclass();
            }
            for (String s : allMethods) {
                outTo.println("    " + s);
            }
        }
    }

    public static enum InputResult {
        kReady,
        kSecondaryPrompt,
        kQuit;

    }

    public static class Builder {
        private ArrayList<String> fHeaderLines = new ArrayList();
        private String fPrompt = "> ";
        private String fSecondaryPrompt = ". ";
        private StdCommandList fCommands = new StdCommandList();
        private HashMap<String, Object> fObjects = new HashMap();

        public Builder withMainPrompt(String prompt) {
            this.fPrompt = prompt;
            return this;
        }

        public Builder withSecondaryPrompt(String prompt) {
            this.fSecondaryPrompt = prompt;
            return this;
        }

        public Builder withPrompts(String prompt, String secondary) {
            this.fPrompt = prompt;
            this.fSecondaryPrompt = secondary;
            return this;
        }

        public Builder presentHeaderLine(String line) {
            this.fHeaderLines.add(line);
            return this;
        }

        public Builder presentHeaderLines(List<String> lines) {
            this.fHeaderLines.addAll(lines);
            return this;
        }

        public Builder addCommand(Command c) {
            this.fCommands.registerCommand(c);
            return this;
        }

        public Builder putObjectInWorkspace(String key, Object o) {
            this.fObjects.put(key, o);
            return this;
        }

        public ConsoleLooper build() {
            ConsoleLooper result = new ConsoleLooper(this.fHeaderLines.toArray(new String[this.fHeaderLines.size()]), this.fPrompt, this.fSecondaryPrompt, this.fCommands);
            for (Map.Entry<String, Object> obj : this.fObjects.entrySet()) {
                result.getWorkspace().put(obj.getKey(), obj.getValue());
            }
            return result;
        }
    }
}

