/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.collections;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class LruCache<K, T> {
    private long fMaxSize;
    private final Hashtable<K, Entry> fEntries = new Hashtable();
    private final LinkedList<K> fMruList = new LinkedList();

    public LruCache(long maxSize) {
        this.setMaxSize(maxSize);
    }

    public T get(K key) {
        return this.get(key, -1L);
    }

    public T get(K key, long maxAgeMs) {
        return this.lookup(key, maxAgeMs);
    }

    public synchronized T lookup(K key) {
        return this.lookup(key, -1L);
    }

    public synchronized T lookup(K key, long maxAgeMs) {
        T t = null;
        Entry e = this.fEntries.get(key);
        if (e != null) {
            long now;
            long age;
            if (maxAgeMs > -1L && (age = (now = System.currentTimeMillis()) - e.initialInsertMs) > maxAgeMs) {
                this.remove(key);
                return null;
            }
            t = e.value;
            this.noteUse(key);
        }
        return t;
    }

    public T put(K key, T object) {
        return this.store(key, object);
    }

    public T store(K key, T object) {
        return this.store(key, object, null);
    }

    public synchronized T store(K key, T object, ExpulsionListener<K, T> el) {
        this.ensureCapacity();
        if ((long)this.fEntries.size() < this.fMaxSize) {
            Entry e = new Entry();
            e.value = object;
            e.expulsion = el;
            e.initialInsertMs = System.currentTimeMillis();
            Entry was = this.fEntries.put(key, e);
            this.noteUse(key);
            return was == null ? null : (T)was.value;
        }
        return null;
    }

    public synchronized T remove(Object key) {
        this.fMruList.remove(key);
        Entry e = this.fEntries.remove(key);
        return e == null ? null : (T)e.value;
    }

    public synchronized void drop(K key) {
        this.remove(key);
    }

    public synchronized int size() {
        return this.fEntries.size();
    }

    public synchronized long maxSize() {
        return this.fMaxSize;
    }

    public synchronized void setMaxSize(long size) {
        if (size < 0L) {
            size = 0L;
        }
        this.fMaxSize = size;
        this.ensureCapacity();
    }

    public void clear() {
        this.clear(false);
    }

    public synchronized void clear(boolean callExpulsionListeners) {
        if (callExpulsionListeners) {
            for (Object key : this.fMruList) {
                Entry e = this.fEntries.get(key);
                if (e == null || e.expulsion == null) continue;
                e.expulsion.onExpelled(key, e.value);
            }
        }
        this.fEntries.clear();
        this.fMruList.clear();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(K key) {
        return this.lookup(key, -1L) != null;
    }

    public synchronized Set<K> keys() {
        return new TreeSet<K>(this.fMruList);
    }

    private void noteUse(K key) {
        this.fMruList.remove(key);
        this.fMruList.addFirst(key);
    }

    private void ensureCapacity() {
        while ((long)this.fEntries.size() >= this.fMaxSize && this.fEntries.size() != 0) {
            K key = this.fMruList.removeLast();
            Entry e = this.fEntries.remove(key);
            if (e.expulsion == null) continue;
            e.expulsion.onExpelled(key, e.value);
        }
    }

    private class Entry {
        T value;
        ExpulsionListener<K, T> expulsion;
        long initialInsertMs;

        private Entry() {
        }
    }

    public static interface ExpulsionListener<K, T> {
        public void onExpelled(K var1, T var2);
    }
}

