/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.client.impl.recovery;

import io.continual.shaded.com.rabbitmq.client.AMQP;
import io.continual.shaded.com.rabbitmq.client.ShutdownSignalException;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.DefaultRetryHandler;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedBinding;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedConsumer;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedEntity;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedQueue;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedQueueBinding;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.TopologyRecoveryRetryHandlerBuilder;
import io.continual.shaded.com.rabbitmq.utility.Utility;
import java.util.function.BiPredicate;

public abstract class TopologyRecoveryRetryLogic {
    public static final BiPredicate<RecordedEntity, Exception> CHANNEL_CLOSED_NOT_FOUND = (entity, ex) -> {
        ShutdownSignalException cause;
        if (ex.getCause() instanceof ShutdownSignalException && (cause = (ShutdownSignalException)ex.getCause()).getReason() instanceof AMQP.Channel.Close) {
            return ((AMQP.Channel.Close)cause.getReason()).getReplyCode() == 404;
        }
        return false;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CHANNEL = context -> {
        if (!context.entity().getChannel().isOpen()) {
            context.connection().recoverChannel(context.entity().getChannel());
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING_QUEUE = context -> {
        if (context.entity() instanceof RecordedQueueBinding) {
            RecordedBinding binding = context.binding();
            AutorecoveringConnection connection = context.connection();
            RecordedQueue recordedQueue = connection.getRecordedQueues().get(binding.getDestination());
            if (recordedQueue != null) {
                connection.recoverQueue(recordedQueue.getName(), recordedQueue, false);
            }
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING = context -> {
        context.binding().recover();
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE = context -> {
        if (context.entity() instanceof RecordedConsumer) {
            RecordedConsumer consumer = context.consumer();
            AutorecoveringConnection connection = context.connection();
            RecordedQueue recordedQueue = connection.getRecordedQueues().get(consumer.getQueue());
            if (recordedQueue != null) {
                connection.recoverQueue(recordedQueue.getName(), recordedQueue, false);
            }
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE_BINDINGS = context -> {
        if (context.entity() instanceof RecordedConsumer) {
            String queue = context.consumer().getQueue();
            for (RecordedBinding recordedBinding : Utility.copy(context.connection().getRecordedBindings())) {
                if (!(recordedBinding instanceof RecordedQueueBinding) || !queue.equals(recordedBinding.getDestination())) continue;
                recordedBinding.recover();
            }
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<String> RECOVER_CONSUMER = context -> context.consumer().recover();
    public static final TopologyRecoveryRetryHandlerBuilder RETRY_ON_QUEUE_NOT_FOUND_RETRY_HANDLER = TopologyRecoveryRetryHandlerBuilder.builder().bindingRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).consumerRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).bindingRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_BINDING_QUEUE).andThen(RECOVER_BINDING)).consumerRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_CONSUMER_QUEUE.andThen(RECOVER_CONSUMER).andThen(RECOVER_CONSUMER_QUEUE_BINDINGS)));
}

