/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.util;

import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Setter {
    public static void evaluateAndSet(MessageProcessingContext context, String key, Object val, boolean appendArray) {
        Message msg = context.getMessage();
        JsonEval.setValue((JSONObject)msg.accessRawJson(), (String)key, (Object)Setter.evaluate(context, val, msg, new ExprDataSource[0]), (boolean)appendArray);
    }

    public static JSONObject evaluate(final MessageProcessingContext mpc, JSONObject value, final Message msg, final ExprDataSource ... addlSrcs) {
        final JSONObject replacement = new JSONObject();
        JsonVisitor.forEachElement((JSONObject)value, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

            public boolean visit(String origKey, Object val) throws JSONException {
                String keyToUse = Setter.evaluateToString(mpc, origKey, msg, addlSrcs);
                replacement.put(keyToUse, Setter.evaluate(mpc, val, msg, addlSrcs));
                return true;
            }
        });
        return replacement;
    }

    public static JSONArray evaluate(final MessageProcessingContext mpc, JSONArray value, final Message msg, final ExprDataSource ... addlSrcs) {
        final JSONArray replacement = new JSONArray();
        JsonVisitor.forEachElement((JSONArray)value, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<Object, JSONException>(){

            public boolean visit(Object val) throws JSONException {
                replacement.put(Setter.evaluate(mpc, val, msg, addlSrcs));
                return true;
            }
        });
        return replacement;
    }

    public static Object evaluate(MessageProcessingContext mpc, Object t, Message msg, ExprDataSource ... addlSrcs) {
        if (t instanceof JSONObject) {
            return Setter.evaluate(mpc, (JSONObject)t, msg, addlSrcs);
        }
        if (t instanceof JSONArray) {
            return Setter.evaluate(mpc, (JSONArray)t, msg, addlSrcs);
        }
        if (t instanceof String) {
            String key = t.toString();
            String val = mpc.evalExpression(key, addlSrcs);
            return val == null ? "" : val;
        }
        return t;
    }

    public static String evaluateToString(MessageProcessingContext mpc, Object t, Message msg, ExprDataSource ... addlSrcs) {
        Object o = Setter.evaluate(mpc, t, msg, addlSrcs);
        return o == null ? "" : o.toString();
    }
}

