/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.util.Setter;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class Set
implements Processor {
    private final JSONObject fUpdates;
    private final boolean fAppendArray;
    private final boolean fEval;

    public Set(JSONObject updates) {
        this.fUpdates = JsonUtil.clone((JSONObject)updates);
        this.fAppendArray = true;
        this.fEval = true;
    }

    public Set(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this.fUpdates = JsonUtil.clone((JSONObject)config.optJSONObject("updates"));
        this.fAppendArray = config.optBoolean("appendArray", true);
        this.fEval = config.optBoolean("eval", true);
    }

    @Override
    public void process(final MessageProcessingContext context) {
        if (this.fUpdates == null) {
            context.warn("No updates provided to Set.");
            return;
        }
        final Message msg = context.getMessage();
        JsonVisitor.forEachElement((JSONObject)this.fUpdates, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

            public boolean visit(String key, Object t) throws JSONException {
                String keyToUse = Set.this.fEval ? Setter.evaluateToString(context, key, msg, new ExprDataSource[0]) : key;
                Object data = Set.this.fEval ? Setter.evaluate(context, t, msg, new ExprDataSource[0]) : t;
                JsonEval.setValue((JSONObject)msg.accessRawJson(), (String)keyToUse, (Object)data, (boolean)Set.this.fAppendArray);
                return true;
            }
        });
    }
}

