/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.util;

import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.impl.noop.NoopMetricsCatalog;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.Source;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExprDataSourceStack;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStreamProcessingContext
implements StreamProcessingContext {
    private final Source fSource;
    private final HashMap<String, Object> fObjects;
    private boolean fFailed;
    private final ExprDataSource fExprEvalStack;
    private final MetricsCatalog fMetrics;
    private final Logger fLog;
    private static final Logger defaultLog = LoggerFactory.getLogger(SimpleStreamProcessingContext.class);

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void warn(String warningText) {
        this.fLog.warn("stream: {}", (Object)warningText);
    }

    @Override
    public void fail(String warningText) {
        this.warn(warningText);
        this.fFailed = true;
    }

    @Override
    public boolean failed() {
        return this.fFailed;
    }

    @Override
    public StreamProcessingContext addNamedObject(String name, Object o) {
        this.fObjects.put(name, o);
        return this;
    }

    @Override
    public Object getNamedObject(String name) {
        return this.fObjects.get(name);
    }

    @Override
    public <T> T getNamedObject(String name, Class<T> clazz) throws ClassCastException {
        Object o = this.getNamedObject(name);
        if (o == null) {
            return null;
        }
        if (!clazz.isInstance(o)) {
            throw new ClassCastException("Object " + name + " is not a " + clazz.getName());
        }
        return (T)o;
    }

    @Override
    public <T> T getReqdNamedObject(String name, Class<T> clazz) throws StreamProcessingContext.NoSuitableObjectException {
        try {
            T obj = this.getNamedObject(name, clazz);
            if (obj == null) {
                throw new StreamProcessingContext.NoSuitableObjectException("No object named " + name + ".");
            }
            return obj;
        }
        catch (ClassCastException x) {
            throw new StreamProcessingContext.NoSuitableObjectException(x);
        }
    }

    @Override
    public StreamProcessingContext removeNamedObject(String name) {
        this.fObjects.remove(name);
        return this;
    }

    @Override
    public boolean setFlag(String flagName) {
        boolean result = this.checkFlag(flagName);
        this.addNamedObject(flagName, Boolean.TRUE);
        return result;
    }

    @Override
    public boolean checkFlag(String flagName) {
        Boolean val = this.getNamedObject(flagName, Boolean.class);
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public boolean clearFlag(String flagName) {
        boolean result = this.checkFlag(flagName);
        this.removeNamedObject(flagName);
        return result;
    }

    @Override
    public void requeue(MessageAndRouting mr) {
        if (this.fSource != null) {
            this.fSource.requeue(mr);
        } else {
            this.warn("Cannot requeue a message without a source in context.");
        }
    }

    @Override
    public String evalExpression(String expression) {
        return ExpressionEvaluator.evaluateText((String)expression, (ExprDataSource[])new ExprDataSource[]{this.fExprEvalStack});
    }

    @Override
    public MetricsCatalog getMetrics() {
        return this.fMetrics;
    }

    private SimpleStreamProcessingContext(Source src, ExprDataSource exprEvalStack, Logger log, MetricsCatalog metrics) {
        this.fSource = src;
        this.fFailed = false;
        this.fObjects = new HashMap();
        this.fExprEvalStack = exprEvalStack;
        this.fLog = log;
        this.fMetrics = metrics;
    }

    static /* synthetic */ Logger access$100() {
        return defaultLog;
    }

    public static class Builder {
        private Source fSource = null;
        private ExprDataSource fEvalStack = new ExprDataSourceStack(new ExprDataSource[0]);
        private Logger fLog = SimpleStreamProcessingContext.access$100();
        private HashMap<String, Object> fData = new HashMap();
        private MetricsCatalog fMetrics = new NoopMetricsCatalog();

        public SimpleStreamProcessingContext build() {
            SimpleStreamProcessingContext sspc = new SimpleStreamProcessingContext(this.fSource, this.fEvalStack, this.fLog, this.fMetrics);
            for (Map.Entry<String, Object> e : this.fData.entrySet()) {
                sspc.addNamedObject(e.getKey(), e.getValue());
            }
            return sspc;
        }

        public Builder withSource(Source s) {
            this.fSource = s;
            return this;
        }

        public Builder loggingTo(Logger log) {
            this.fLog = log;
            return this;
        }

        public Builder evaluatingAgainst(ExprDataSource eval) {
            this.fEvalStack = eval;
            return this;
        }

        public Builder holdingObject(String key, Object obj) {
            this.fData.put(key, obj);
            return this;
        }

        public Builder reportMetricsTo(MetricsCatalog metrics) {
            this.fMetrics = metrics;
            return this;
        }
    }
}

